/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.cmdrun;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.cmdrun.CommandOutputHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class UpstreamWriter
implements Runnable {
    private final InputStream streamFromSubProcess;
    private final PrintStream pushUpStream;
    private final CommandOutputHandler outputHandler;
    private BufferedWriter fileWriter;

    protected UpstreamWriter(CommandOutputHandler outputHandler, InputStream streamFromSubProcess, PrintStream pushUpStream) throws SimTreeException {
        this.streamFromSubProcess = streamFromSubProcess;
        this.pushUpStream = pushUpStream;
        this.outputHandler = outputHandler;
        if (outputHandler.saveFileName != null) {
            File file = new File(outputHandler.saveFileName);
            if (file.exists()) {
                file.delete();
            }
            if (file.exists()) {
                throw new SimTreeException("Cannot delete output file " + outputHandler.saveFileName);
            }
            try {
                this.fileWriter = new BufferedWriter(new FileWriter(new File(outputHandler.saveFileName)));
            }
            catch (IOException e) {
                throw new SimTreeException("Cannot create output file " + outputHandler.saveFileName + " (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.streamFromSubProcess));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                this.outputHandler.addToStringList(s);
                this.outputHandler.addStatusMessage(s);
                if (this.outputHandler.pushUp) {
                    this.pushUpStream.println(s);
                    this.pushUpStream.flush();
                }
                if (this.fileWriter == null) continue;
                this.fileWriter.write(String.valueOf(s) + "\n");
                this.fileWriter.flush();
            }
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
            reader.close();
        }
        catch (IOException e) {
            Message.debug("OutputHandler caught IOException: " + e.getMessage());
        }
    }
}

