/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.cmdrun;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.cmdrun.CommandReturn;
import ikr.simtree.cmdrun.StdinDownstreamPusher;
import ikr.simtree.cmdrun.UpstreamWriter;
import ikr.simtree.control.ProcessDescription;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.workingset.WorkDesc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class CommandRunner {
    private final SimTreeContext sc;
    private final File workingDir;
    private String nameOfFileToDelete = null;
    private Strings stdinContent = null;
    private boolean passThroughStdin = false;
    private boolean handleProcessList = false;
    private WorkDesc workDesc = null;

    public CommandRunner(String workingDirName, SimTreeContext sc) {
        this.sc = sc;
        this.workingDir = new File(workingDirName);
    }

    public void enablePassThroughStdin() {
        this.passThroughStdin = true;
    }

    public void enableHandleProcessList() {
        this.handleProcessList = true;
    }

    public void setNameOfFileToDelete(String nameOfFileToDelete) {
        this.nameOfFileToDelete = nameOfFileToDelete;
    }

    public void setWorkDesc(WorkDesc workDesc) {
        this.workDesc = workDesc;
    }

    public void setStdinContent(Strings stdinContent) {
        this.stdinContent = stdinContent;
    }

    public CommandReturn run(String command, CommandOutputHandler stdoutHandler, CommandOutputHandler stderrHandler) throws SimTreeException {
        return this.run(new String[]{command}, stdoutHandler, stderrHandler);
    }

    public CommandReturn run(String[] command, CommandOutputHandler stdoutHandler, CommandOutputHandler stderrHandler) throws SimTreeException {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(this.workingDir);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            throw new SimTreeException("Starting command  " + command[0] + "failed (" + e.getMessage() + ")");
        }
        if (process == null) {
            throw new SimTreeException("Cannot create process for command  " + command[0]);
        }
        ProcessDescription processDescription = null;
        if (this.handleProcessList) {
            processDescription = new ProcessDescription(process, stdoutHandler, this.workDesc);
            this.sc.getCurrentProcessList().add(processDescription);
        }
        Thread stdoutWriterThread = new Thread(new UpstreamWriter(stdoutHandler, process.getInputStream(), System.out));
        Thread stderrWriterThread = new Thread(new UpstreamWriter(stderrHandler, process.getErrorStream(), System.err));
        stdoutWriterThread.start();
        stderrWriterThread.start();
        BufferedWriter stdinWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        if (this.stdinContent != null) {
            try {
                for (String s : this.stdinContent) {
                    stdinWriter.write(String.valueOf(s) + "\n");
                }
                stdinWriter.flush();
            }
            catch (IOException e) {
                throw new SimTreeException("Writing stdin to command " + command[0] + "failed (" + e.getMessage() + ")");
            }
        }
        StdinDownstreamPusher stdinPusher = null;
        if (this.passThroughStdin) {
            stdinPusher = new StdinDownstreamPusher(stdinWriter);
            new Thread(stdinPusher).start();
        }
        int exitValue = -1;
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (stdinPusher != null) {
            stdinPusher.stopThread = true;
        }
        if (this.handleProcessList) {
            this.sc.getCurrentProcessList().remove(processDescription);
        }
        while (stdoutWriterThread.isAlive() || stderrWriterThread.isAlive()) {
            Helpers.pauseThread(100L);
        }
        process.destroy();
        if (this.nameOfFileToDelete != null && !new File(this.nameOfFileToDelete).delete()) {
            Message.warning("Cannot delete file " + this.nameOfFileToDelete, this.sc);
        }
        return new CommandReturn(exitValue);
    }
}

