/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree;

import ikr.simtree.base.Message;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commandline.CommandLine;
import ikr.simtree.eval.ResultFile;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.TextFormatter;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.MaxDepthOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.ResultPathOption;
import ikr.simtree.options.SingleArgOption;
import ikr.simtree.parser.ResultFileParser;
import ikr.simtree.parser.ResultFilesParser;
import ikr.simtree.query.ParserDumpHandler;
import java.io.File;
import java.util.ArrayList;

public class StandaloneParser {
    private static void usage(String progName, boolean visual) throws SimTreeException {
        System.err.println("Usage: " + progName + " <Options>");
        System.err.println("  where Options are");
        HelpParas helpParas = new HelpParas();
        ArrayList<OptionEnum> oList = new ArrayList<OptionEnum>();
        oList.add(OptionEnum.RESULT_FILE_NAME);
        oList.add(OptionEnum.RESULT_PATH);
        if (!visual) {
            oList.add(OptionEnum.MAX_DEPTH);
        }
        oList.add(OptionEnum.VERBOSE);
        helpParas.add(OptionEnum.getShortHelpForOptionList(oList, 2));
        new TextFormatter(helpParas).print();
        System.err.println("  of which " + OptionEnum.RESULT_FILE_NAME.longNameWithStarter + " is required");
        throw new SimTreeException("Program terminated");
    }

    protected static void parse(String[] args, String progName, boolean visual) {
        SimTreeContext sc = new SimTreeContext();
        try {
            Props.init();
            CommandLine commandLine = new CommandLine(args);
            Options options = Options.fromUnparsedOptions(commandLine.getUnparsedOptions(), OptionSourceEnum.COMMAND_LINE, sc);
            if (options.size() == 0 || commandLine.getCommand().equalsIgnoreCase("help") || options.getOptions(OptionEnum.HELP).size() != 0) {
                StandaloneParser.usage(progName, visual);
            }
            String fileName = null;
            String resultPath = ".*";
            int maxDepth = -1;
            Options ol = options.getOptions(OptionEnum.RESULT_PATH);
            if (ol.size() != 0) {
                if (ol.size() != 1) {
                    throw new SimTreeException("Cannot handle more than one result path");
                }
                resultPath = ((ResultPathOption)ol.get(0)).getResultSource().getUnmodifiedPath().toComposedString();
            }
            if ((ol = options.getOptions(OptionEnum.MAX_DEPTH)).size() != 0) {
                if (visual) {
                    StandaloneParser.usage(progName, visual);
                }
                maxDepth = ((MaxDepthOption)ol.get(0)).getMaxDepth();
            }
            if ((ol = options.getOptions(OptionEnum.RESULT_FILE_NAME)).size() != 0) {
                fileName = ((SingleArgOption)ol.get(0)).getSingleArg();
            }
            if (fileName == null) {
                StandaloneParser.usage(progName, visual);
            }
            File file = new File(fileName);
            ResultFilesParser.parseResultFile(file, new ResultFileParser(new ResultFile(file), new ParserDumpHandler("Content of " + file.getAbsolutePath(), visual, new PrintServerPath(resultPath), "", maxDepth, new SimTreeContext()), sc));
        }
        catch (SimTreeException e) {
            Message.fatal(e.getMessage(), sc);
        }
    }
}

