/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.workingset;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.simpara.SimParaPath;

public class WorkDesc {
    public final SimParaPath simParaPath;
    public final ResultDef resultDef;

    public WorkDesc(SimParaPath simParaPath, ResultDef resultDef) {
        assert (simParaPath != null);
        assert (resultDef != null);
        this.simParaPath = simParaPath;
        this.resultDef = resultDef;
    }

    public WorkDesc(SimParaPath simParaPath) {
        assert (simParaPath != null);
        this.simParaPath = simParaPath;
        this.resultDef = null;
    }

    public String toFormattedString() {
        return String.valueOf(this.simParaPath.toFormattedString()) + " " + (this.resultDef != null ? this.resultDef.getFullDisplayStringWithBrackets() : "");
    }

    public boolean matches(WorkDesc newWorkDesc, boolean handleRemove) throws SimTreeException {
        if (!this.simParaPath.equals(newWorkDesc.simParaPath)) {
            return false;
        }
        ResultDef newResultDef = newWorkDesc.resultDef;
        if (this.resultDef == null && newResultDef == null) {
            return true;
        }
        if (this.resultDef == null && newResultDef != null) {
            throw new SimTreeException("Result Definition not allowed");
        }
        if (this.resultDef != null && newResultDef == null) {
            return handleRemove;
        }
        if (this.resultDef != null && newResultDef != null) {
            if (this.resultDef.getOptionEnum() != newResultDef.getOptionEnum()) {
                throw new SimTreeException("Result Definitions not compatible");
            }
            assert (this.resultDef.getOptionEnum() != null);
            if (!this.resultDef.getSeedDef().equals(newResultDef.getSeedDef())) {
                return false;
            }
            return this.resultDef.getPartTestNums().equals(newResultDef.getPartTestNums());
        }
        return false;
    }
}

