/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.vfs.results.tree;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.simpara.SimParaPathList;
import ikr.simtree.simpara.SimParas;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.vfs.results.node.SimulationMethodEnum;
import ikr.simtree.vfs.results.tree.ResultsTreeVFS;

public abstract class ResultsTreeState {
    private static SimulationMethodEnum simulationMethod;
    private static SimParaPathList currentResultsTreeContent;

    public static SimulationMethodEnum getSimulationMethod(boolean required, SimTreeContext sc) throws SimTreeException {
        ResultsTreeState.updateState(sc);
        if (simulationMethod == null && required) {
            throw new SimTreeException("Cannot determine simulation method when required");
        }
        return simulationMethod;
    }

    public static SimParaPathList getCurrentTreeContent(SimTreeContext sc) throws SimTreeException {
        ResultsTreeState.updateState(sc);
        assert (currentResultsTreeContent != null);
        return currentResultsTreeContent.getPathListClone();
    }

    public static void checkTreeConsistency(SimTreeContext sc) throws SimTreeException {
        ResultsTreeState.updateState(sc);
    }

    private static void updateState(SimTreeContext sc) throws SimTreeException {
        if (currentResultsTreeContent == null) {
            currentResultsTreeContent = new SimParaPathList();
            ResultsTreeState.inner(currentResultsTreeContent, new SimParaPath(), sc);
        }
    }

    private static void inner(SimParaPathList currentList, SimParaPath currentPath, SimTreeContext sc) throws SimTreeException {
        ResultsTreeState.setSimulationMethod(new ResultNodeVFS(currentPath, sc).detectSimulationMethod());
        SimParas simParasInCurrentDir = new ResultsTreeVFS(currentPath).listDir();
        if (simParasInCurrentDir.size() == 0 && currentPath.size() != 0) {
            currentList.add(currentPath);
        }
        for (SimPara simPara : simParasInCurrentDir) {
            SimParaPath newPath = currentPath.clonePath();
            newPath.add(simPara);
            ResultsTreeState.inner(currentList, newPath, sc);
        }
    }

    public static void stateSimulationParametersWereModified() {
        currentResultsTreeContent = null;
    }

    private static void setSimulationMethod(SimulationMethodEnum newSimulationMethod) throws SimTreeException {
        if (simulationMethod != null && newSimulationMethod != null && newSimulationMethod != simulationMethod) {
            throw new SimTreeException("Inconsistent tree, contains entries for more than one simulation method");
        }
        if (newSimulationMethod != null) {
            simulationMethod = newSimulationMethod;
        }
    }
}

