/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.vfs.results.node;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.vfs.results.node.PackedFile;
import java.io.File;

public class ResultFileName {
    private static final String FNAME_EXT_RESULTS = ".log";
    private static final String FNAME_EXT_GZ = ".gz";
    private static final String FNAME_EXT_BZ2 = ".bz2";
    private static final String FNAME_EXT_LZMA = ".lzma";
    private static final String FNAME_FINALRESULTS = "FinalResults.log";
    private static final String SEP = File.separator;
    private final String absPath;

    public ResultFileName(String absPath) {
        this.absPath = absPath;
    }

    public boolean isGZPacked() {
        return this.absPath.endsWith(".log.gz");
    }

    public boolean isLZMAPacked() {
        return this.absPath.endsWith(".log.lzma");
    }

    public boolean isLBZ2Packed() {
        return this.absPath.endsWith(".log.bz2");
    }

    public boolean isUnPacked() {
        return this.absPath.endsWith(FNAME_EXT_RESULTS);
    }

    protected static boolean isValidResultFileName(String relFileName, String fileNameBase) {
        return relFileName.startsWith(fileNameBase) && (relFileName.endsWith(FNAME_EXT_RESULTS) || relFileName.endsWith(".log.gz") || relFileName.endsWith(".log.bz2") || relFileName.endsWith(".log.lzma"));
    }

    protected static void removeResultFile(String absFileNameBase) {
        new PackedFile(String.valueOf(absFileNameBase) + FNAME_EXT_RESULTS).remove();
    }

    private static File getPackedOrUnpackedFile(String absResultFileName, SimTreeContext sc) {
        assert (absResultFileName.endsWith(FNAME_EXT_RESULTS));
        File fPackedGZ = new File(String.valueOf(absResultFileName) + FNAME_EXT_GZ);
        File fPackedBZ2 = new File(String.valueOf(absResultFileName) + FNAME_EXT_BZ2);
        File fPackedLZMA = new File(String.valueOf(absResultFileName) + FNAME_EXT_LZMA);
        File fUnpacked = new File(absResultFileName);
        if (FileOPs.existsFile(fPackedBZ2)) {
            if (FileOPs.existsFile(fUnpacked) || FileOPs.existsFile(fPackedGZ) || FileOPs.existsFile(fPackedLZMA)) {
                Message.warning(String.valueOf(StudyRootVFS.reduceName(absResultFileName)) + " exists with different compression, using bz2", sc);
            }
            return fPackedBZ2;
        }
        if (FileOPs.existsFile(fPackedGZ)) {
            if (FileOPs.existsFile(fUnpacked) || FileOPs.existsFile(fPackedLZMA)) {
                Message.warning(String.valueOf(StudyRootVFS.reduceName(absResultFileName)) + " exists with different compression, using gz", sc);
            }
            return fPackedGZ;
        }
        if (FileOPs.existsFile(fPackedLZMA)) {
            if (FileOPs.existsFile(fUnpacked)) {
                Message.warning(String.valueOf(StudyRootVFS.reduceName(absResultFileName)) + " exists with different compression, using lzma", sc);
            }
            return fPackedLZMA;
        }
        if (FileOPs.existsFile(fUnpacked)) {
            return fUnpacked;
        }
        return null;
    }

    protected static String getResultFilenameWithoutExtension(String fullName) {
        int index = fullName.indexOf(FNAME_EXT_RESULTS);
        if (index == -1) {
            return null;
        }
        if (!(fullName.endsWith(FNAME_EXT_RESULTS) || fullName.endsWith(".log.gz") || fullName.endsWith(".log.bz2") || fullName.endsWith(".log.lzma"))) {
            return null;
        }
        String ret = fullName.substring(0, index);
        if (ret.length() == 0) {
            return null;
        }
        return ret;
    }

    protected static String getResultFileExtensionForNewFiles() {
        return FNAME_EXT_RESULTS;
    }

    protected static String getFinalResultRelFileNameForNewFiles() {
        return FNAME_FINALRESULTS;
    }

    protected static File getFinalResultFile(String absDirName, SimTreeContext sc) {
        return ResultFileName.getPackedOrUnpackedFile(String.valueOf(absDirName) + SEP + FNAME_FINALRESULTS, sc);
    }

    protected static void removeFinalResultsFile(String absDirName) {
        new PackedFile(String.valueOf(absDirName) + SEP + FNAME_FINALRESULTS).remove();
    }

    protected static String findResultFile(String absBaseDir, String fnameStart) throws SimTreeException {
        File dir = new File(absBaseDir);
        assert (dir.isDirectory());
        String[] dirContent = FileOPs.listDir(absBaseDir);
        String ret = null;
        String[] stringArray = dirContent;
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            String dirEntry = stringArray[n2];
            if (ResultFileName.isValidResultFileName(dirEntry, fnameStart)) {
                assert (ret == null);
                ret = dirEntry;
            }
            ++n2;
        }
        return ret;
    }
}

