/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.vfs;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Message;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import java.io.File;

public abstract class StudyRootVFS {
    private static final String USER_HOME = System.getenv("HOME");
    private static final String DIRNAME_RESULTS = "Results";
    private static final String DIRNAME_METADATA = "MetaData";
    private static final String DIRNAME_HOOKS = "Hooks";
    private static final String DIRNAME_TEMP = "Temp";
    private static final String[] studyRootSubDirList = new String[]{"MetaData", "Results", "Temp"};
    private static String studyRoot = null;

    public static String getStudyRoot() {
        return studyRoot;
    }

    public static String getPropertiesFileName() {
        if (studyRoot == null) {
            return null;
        }
        return String.valueOf(StudyRootVFS.getMetadataDirName()) + File.separator + "simtree.properties";
    }

    public static void setStudyRoot(String newStudyRoot) {
        assert (newStudyRoot != null);
        if (studyRoot != null) assert (newStudyRoot.equals(studyRoot));
        if (newStudyRoot != null) {
            studyRoot = FileOPs.toAbsolutePath(newStudyRoot);
        }
    }

    public static void checkStudyRoot(SimTreeContext sc) throws SimTreeException {
        assert (studyRoot != null);
        String s = "StudyRoot directory " + StudyRootVFS.getStudyRoot() + " ";
        File sr = new File(StudyRootVFS.getStudyRoot());
        if (!FileOPs.isDir(sr)) {
            throw new SimTreeException(String.valueOf(s) + "does not exist or is not a directory");
        }
        if (!sr.canRead()) {
            throw new SimTreeException(String.valueOf(s) + "is not readable");
        }
        if (!sr.canWrite()) {
            Message.warning(String.valueOf(s) + "is not writable", sc);
        }
    }

    public static void prepare() throws SimTreeException {
        String[] stringArray = studyRootSubDirList;
        int n = studyRootSubDirList.length;
        int n2 = 0;
        while (n2 < n) {
            String subDir = stringArray[n2];
            FileOPs.mkDirs(String.valueOf(StudyRootVFS.getStudyRoot()) + File.separator + subDir);
            ++n2;
        }
        FileOPs.mkDirs(StudyRootVFS.getHooksDirName());
    }

    public static void checkStudyRootSubDirs() throws SimTreeException {
        if (!FileOPs.isDir(StudyRootVFS.getResultsDirName()) || !FileOPs.isDir(StudyRootVFS.getMetadataDirName())) {
            throw new SimTreeException("Required directory in StudyRoot does not exist, please change to a valid StudyRoot or use SimTree prepare");
        }
        if (!FileOPs.isDir(StudyRootVFS.getHooksDirName())) {
            StudyRootVFS.prepare();
        }
    }

    public static String getResultsDirName() {
        return String.valueOf(studyRoot) + File.separator + DIRNAME_RESULTS;
    }

    public static String getMetadataDirName() {
        return String.valueOf(studyRoot) + File.separator + DIRNAME_METADATA;
    }

    public static String getTempDirName() {
        return String.valueOf(studyRoot) + File.separator + DIRNAME_TEMP;
    }

    public static String getHooksDirName() {
        return String.valueOf(studyRoot) + File.separator + DIRNAME_METADATA + File.separator + DIRNAME_HOOKS;
    }

    private static String createCanonName() throws SimTreeException {
        if (USER_HOME == null) {
            throw new SimTreeException("Cannot get users home directory from environment");
        }
        String relDir = StudyRootVFS.getStudyRoot();
        if (relDir.startsWith(USER_HOME)) {
            relDir = relDir.substring(USER_HOME.length());
        }
        return relDir.replaceAll("\\Q" + File.separator + ".\\E", "").replaceAll("\\Q" + File.separator + "\\E", "_");
    }

    public static String createAndGetControlSocketDirName() throws SimTreeException {
        if (USER_HOME == null) {
            throw new SimTreeException("Cannot get users home directory from environment");
        }
        String dName = String.valueOf(USER_HOME) + File.separator + ".simtree" + File.separator + StudyRootVFS.createCanonName();
        File dir = new File(dName);
        if (!dir.isDirectory()) {
            FileOPs.mkDirs(dName);
        }
        if (!dir.isDirectory()) {
            throw new SimTreeException("Cannot create directory for control socket " + dName);
        }
        return dName;
    }

    private static String reduceName(String fname, boolean parasOnly) {
        if (fname.startsWith(StudyRootVFS.getStudyRoot())) {
            String ret = parasOnly ? "" : "<StudyRoot>";
            String s = fname.substring(StudyRootVFS.getStudyRoot().length());
            if (!s.startsWith(File.separator)) {
                return fname;
            }
            s = s.substring(1);
            String[] p = s.split(File.separator);
            if (p[0].equals(DIRNAME_RESULTS) && p.length > 1) {
                SimParaPath path;
                if (!parasOnly) {
                    ret = String.valueOf(ret) + File.separator + DIRNAME_RESULTS + File.separator;
                }
                if ((path = SimParaPath.fromAbsDirName(fname)) != null) {
                    ret = String.valueOf(ret) + path.toFormattedString(SimPara.FormatEnum.PLAIN);
                    String[] remaining = SimParaPath.removeLeadingSimParaPath(fname);
                    if (remaining == null) {
                        return ret;
                    }
                    String[] stringArray = remaining;
                    int n = remaining.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        ret = String.valueOf(ret) + " [" + str + "]";
                        ++n2;
                    }
                    return ret;
                }
                return fname;
            }
            return (String.valueOf(ret) + File.separator + s).trim();
        }
        return fname;
    }

    public static String reduceName(String fname) {
        return StudyRootVFS.reduceName(fname, false);
    }

    public static String getDefaultConfigFileName() {
        return String.valueOf(StudyRootVFS.getMetadataDirName()) + File.separator + Props.getStr("st.s.outerr_filename_base.1") + Props.getStr("st.s.config_filename_ext.1");
    }

    public static String getFileBasenameWithDash() {
        return String.valueOf(Props.getStr("st.s.outerr_filename_base.1")) + "-";
    }

    public static String getParaFileTemplateAbsName() {
        return FileOPs.toAbsolutePath(String.valueOf(StudyRootVFS.getMetadataDirName()) + File.separator + Props.getStr("st.s.parafile_template_filename.1"));
    }

    public static String getAttributesFileAbsName() {
        return FileOPs.toAbsolutePath(String.valueOf(StudyRootVFS.getMetadataDirName()) + File.separator + Props.getStr("st.s.attributes_filename.1"));
    }

    public static String getCustomConfigFileName(String configName) {
        return String.valueOf(StudyRootVFS.getMetadataDirName()) + File.separator + StudyRootVFS.getFileBasenameWithDash() + configName + Props.getStr("st.s.config_filename_ext.1");
    }

    public static String resolveFilenameToAbsolutePath(String path) throws SimTreeException {
        File abs;
        String ret = path.startsWith(File.separator) ? FileOPs.toAbsolutePath(path) : (FileOPs.existsFile(abs = new File(String.valueOf(StudyRootVFS.getMetadataDirName()) + File.separator + path)) ? abs.getAbsolutePath() : new File(path).getAbsolutePath());
        if (!FileOPs.isFileReadable(ret)) {
            if (path.startsWith(File.separator)) {
                throw new SimTreeException("File " + path + " does not exist or is not readable");
            }
            throw new SimTreeException("Cannot resolve " + path + " in current directory or in " + StudyRootVFS.reduceName(StudyRootVFS.getMetadataDirName()) + " or file is not readable");
        }
        return ret;
    }
}

