/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.simpara;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaTypeEnum;
import ikr.simtree.simpara.ValuePattern;
import java.util.ArrayList;

public class ValuePatterns
extends ArrayList<ValuePattern> {
    public final boolean useValuesNotInList;

    public ValuePatterns(String valueString, boolean useValuesNotInList, SimParaTypeEnum paraType) throws SimTreeException {
        this.add(new ValuePattern(valueString));
        this.useValuesNotInList = useValuesNotInList;
        this.checkValueTypes(paraType);
    }

    public ValuePatterns() {
        this.useValuesNotInList = false;
    }

    public ValuePatterns(Strings valueStrings, int beginIndex, SimParaTypeEnum paraType) throws SimTreeException {
        int currentArg = beginIndex;
        boolean iUseNot = false;
        if (currentArg < valueStrings.size()) {
            if (((String)valueStrings.get(currentArg)).equals("!")) {
                iUseNot = true;
                ++currentArg;
            }
            if (currentArg >= valueStrings.size() && iUseNot) {
                throw new SimTreeException("Must give at least one value when not-Operator is set");
            }
            if (((String)valueStrings.get(currentArg)).equals("seq")) {
                if (paraType == null) {
                    throw new SimTreeException("Please specifiy the parameter type for evaluating the value sequence");
                }
                if (++currentArg + 3 > valueStrings.size()) {
                    throw new SimTreeException("A sequence requires exactly 3 parameters (start, increment, end)");
                }
                String startStr = (String)valueStrings.get(currentArg++);
                String incrStr = (String)valueStrings.get(currentArg++);
                String endStr = (String)valueStrings.get(currentArg++);
                ValuePattern valuePattern = null;
                switch (paraType) {
                    case INT: {
                        int startI = 0;
                        int incrI = 0;
                        int endI = 0;
                        try {
                            startI = new Integer(startStr);
                            incrI = new Integer(incrStr);
                            endI = new Integer(endStr);
                        }
                        catch (NumberFormatException e) {
                            throw new SimTreeException("Invalid number format for integer sequence");
                        }
                        int i = startI;
                        while (i <= endI) {
                            valuePattern = new ValuePattern("" + i);
                            this.add(valuePattern);
                            i += incrI;
                        }
                        break;
                    }
                    case FLOAT: {
                        double startD = 0.0;
                        double incrD = 0.0;
                        double endD = 0.0;
                        try {
                            startD = new Double(startStr);
                            incrD = new Double(incrStr);
                            endD = new Double(endStr);
                        }
                        catch (NumberFormatException e) {
                            throw new SimTreeException("Invalid number format for float sequence");
                        }
                        double delta = 0.001;
                        if (Math.abs(incrD) < delta) {
                            throw new SimTreeException("Increment too small (danger of rounding errors), please contact program author");
                        }
                        double i = startD;
                        while (i <= endD + delta) {
                            double d = (double)Math.round(i * 1000.0) / 1000.0;
                            valuePattern = new ValuePattern("" + d);
                            this.add(valuePattern);
                            i += incrD;
                        }
                        break;
                    }
                    case STRING: {
                        throw new SimTreeException("Sequence not defined for type string");
                    }
                    case BOOL: {
                        throw new SimTreeException("Sequence not defined for type bool");
                    }
                }
                if (valuePattern != null && valuePattern.isRegExp()) {
                    throw new SimTreeException("Regular expression not allowed for sequence");
                }
            } else {
                int i = currentArg;
                while (i < valueStrings.size()) {
                    String value = (String)valueStrings.get(i);
                    if (value.equals("!")) {
                        throw new SimTreeException("! is only allowed for the whole list of values");
                    }
                    this.add(new ValuePattern(value));
                    ++i;
                }
                if (paraType != null) {
                    this.checkValueTypes(paraType);
                }
            }
            if (iUseNot && this.size() == 0) {
                throw new SimTreeException("Must give values when not-Operator is set");
            }
            int i = 0;
            while (i < this.size()) {
                int j = 0;
                while (j < this.size()) {
                    if (i != j && !((ValuePattern)this.get(i)).isRegExp() && !((ValuePattern)this.get(j)).isRegExp() && ((ValuePattern)this.get(i)).equals(this.get(j))) {
                        throw new SimTreeException("Double value " + this.get(i) + " in list");
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.useValuesNotInList = iUseNot;
    }

    public Strings getRawValues() throws SimTreeException {
        Strings ret = new Strings();
        for (ValuePattern p : this) {
            if (p.isRegExp()) {
                throw new SimTreeException("Cannot handle regular expressions in simulation parameter values for this operation");
            }
            ret.add(p.getRawValue());
        }
        return ret;
    }

    public void checkValueTypes(SimParaTypeEnum paraType) throws SimTreeException {
        assert (paraType != null);
        for (ValuePattern p : this) {
            p.checkValueType(paraType);
        }
    }

    public boolean matches(SimPara simPara) throws SimTreeException {
        for (ValuePattern p : this) {
            if (!(!p.isRegExp() ? simPara.isValueEqual(p.getRawValue()) : p.matches(simPara.getStringValue()))) continue;
            return this.useValuesNotInList;
        }
        return !this.useValuesNotInList;
    }
}

