/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.simpara;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.File;
import java.util.ArrayList;

public class SimParaPath
extends ArrayList<SimPara>
implements Comparable<SimParaPath> {
    public SimParaPath clonePath() {
        SimParaPath ret = new SimParaPath();
        for (SimPara simPara : this) {
            ret.add(simPara.clonePara());
        }
        return ret;
    }

    @Override
    public int compareTo(SimParaPath other) {
        int shorterLen = this.size() < other.size() ? this.size() : other.size();
        int i = 0;
        while (i < shorterLen) {
            int r = ((SimPara)this.get(i)).compareTo((SimPara)other.get(i));
            if (r != 0) {
                return r;
            }
            ++i;
        }
        if (this.size() < other.size()) {
            return -1;
        }
        if (this.size() > other.size()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(SimParaPath other) {
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (!((SimPara)this.get(i)).equals((SimPara)other.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static SimParaPath fromAbsDirName(String absDirName) {
        String[] pArr;
        String canonAbsDirName = FileOPs.toAbsolutePath(absDirName);
        SimParaPath ret = new SimParaPath();
        String start = String.valueOf(StudyRootVFS.getResultsDirName()) + File.separator;
        if (!canonAbsDirName.startsWith(start)) {
            return null;
        }
        String p = canonAbsDirName.substring(start.length());
        String[] stringArray = pArr = p.split(File.separator);
        int n = pArr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            try {
                SimPara para = new SimPara(str);
                ret.add(para);
            }
            catch (SimTreeException e) {
                return ret;
            }
            ++n2;
        }
        return ret;
    }

    public static String[] removeLeadingSimParaPath(String absDirName) {
        SimParaPath path = SimParaPath.fromAbsDirName(absDirName);
        if (path == null) {
            return null;
        }
        String canonAbsDirName = FileOPs.toAbsolutePath(absDirName);
        String start = String.valueOf(StudyRootVFS.getResultsDirName()) + File.separator;
        assert (canonAbsDirName.startsWith(start));
        String p = canonAbsDirName.substring(start.length());
        String[] pArr = p.split(File.separator);
        assert (path.size() <= pArr.length);
        if (path.size() == pArr.length) {
            return null;
        }
        String[] ret = new String[pArr.length - path.size()];
        int i = 0;
        while (i < pArr.length - path.size()) {
            ret[i] = pArr[path.size() + i];
            ++i;
        }
        return ret;
    }

    public File toAbsoluteDir() {
        return new File(this.toAbsoluteDirName());
    }

    public String toAbsoluteDirName() {
        String ret = StudyRootVFS.getResultsDirName();
        for (SimPara simPara : this) {
            ret = String.valueOf(ret) + File.separator + simPara.toDirName();
        }
        return ret;
    }

    public String toFormattedString(SimPara.FormatEnum formatEnum) {
        String ret = "";
        int i = 0;
        while (i < this.size()) {
            SimPara simPara = (SimPara)this.get(i);
            String app = null;
            switch (formatEnum) {
                case PLAIN: 
                case OPTION: 
                case OPTION_SHORT: {
                    app = i == this.size() - 1 ? "" : " ";
                    break;
                }
                case OPTION_SPP: {
                    app = i == this.size() - 1 ? "" : ":";
                }
            }
            ret = String.valueOf(ret) + simPara.toFormattedString(formatEnum) + app;
            ++i;
        }
        return ret;
    }

    public String toFormattedString() {
        return this.toFormattedString(SimPara.FormatEnum.PLAIN);
    }

    public SimPara getSimParaFromName(String simParaName) {
        SimPara ret = null;
        assert (simParaName != null);
        assert (simParaName.length() != 0);
        for (SimPara simPara : this) {
            if (!simPara.getParaName().equals(simParaName)) continue;
            assert (ret == null);
            ret = simPara;
        }
        return ret;
    }
}

