/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.runsim;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.parafile.AttributesLists;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.runsim.ProcessSlot;
import ikr.simtree.runsim.SimThread;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.StringWorkItemInfo;
import ikr.simtree.workingset.WorkItem;

public class RunSim {
    public static void runSim(WorkItem workItem, CommandEnum remoteCommand, ProcessSlot processSlot, ResultNodeVFS rnVFS, String simulationBinaryPath, String paramFileTemplateName, String filterFileName, AttributesLists attributesLists, boolean isSimTreeParent, SimTreeContext sc) throws SimTreeException {
        assert (simulationBinaryPath != null);
        assert (rnVFS != null);
        assert (workItem != null);
        assert (processSlot != null);
        ResultDef resultDef = workItem.workDesc.resultDef;
        String cmdLine = "";
        cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.CHILD);
        cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.IGNORE_DEFAULT_CONFIG);
        cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.STUDY_ROOT, StudyRootVFS.getStudyRoot());
        if (sc.isVeryVerbose()) {
            cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.VERY_VERBOSE);
        } else if (sc.isVerbose()) {
            cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.VERBOSE);
        }
        SimParaPath simParaPath = rnVFS.getSimParaPath();
        String workingDirName = rnVFS.getAbsWorkingDirName(resultDef);
        String command = "SimTree ";
        if (processSlot.isLocal()) {
            try {
                rnVFS.prepareExecutionEnvironment(remoteCommand, paramFileTemplateName, filterFileName, attributesLists, resultDef, simulationBinaryPath);
            }
            catch (SimTreeException e) {
                Message.error("Cannot create execution environment for " + simParaPath.toFormattedString() + " (" + e.getMessage() + ")", sc);
                Helpers.setExitValue(-1);
                workItem.addInfo(new StringWorkItemInfo("(Failed)", true));
                workItem.fromRunningToFinished();
                return;
            }
            command = String.valueOf(command) + CommandEnum.EXEC.commandName;
            cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.WORKING_DIRECTORY, workingDirName);
        } else {
            FileOPs.mkDirs(workingDirName);
            command = String.valueOf(command) + remoteCommand.commandName;
            cmdLine = String.valueOf(cmdLine) + " " + simParaPath.toFormattedString(SimPara.FormatEnum.OPTION_SHORT);
            cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.LOCAL_PROCESS_SLOTS, "1");
            if (remoteCommand == CommandEnum.SIMULATE) {
                cmdLine = String.valueOf(cmdLine) + Option.option2commandline(resultDef.getOptionEnum(), resultDef.getOptionArgumentString());
            }
            cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.SIMULATION_BINARY, FileOPs.toAbsolutePath(simulationBinaryPath));
            cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.PARAMETER_FILE_TEMPLATE, paramFileTemplateName);
            if (filterFileName != null) {
                cmdLine = String.valueOf(cmdLine) + Option.option2commandline(OptionEnum.FILTER_FILE, filterFileName);
            }
        }
        Thread simThread = new Thread(new SimThread(workItem, processSlot, workingDirName, command, cmdLine, simParaPath, isSimTreeParent, sc));
        simThread.setName(SimThread.createUniqueName(simThread));
        simThread.start();
    }
}

