/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.runsim;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.LocalProcessSlotsOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.RemoteProcessSlotsOption;
import ikr.simtree.runsim.FinishMessageDisplayer;
import ikr.simtree.runsim.ProcessSlot;
import ikr.simtree.runsim.ProcessSlots;

public class ProcessScheduler {
    private FinishMessageDisplayer finishMessageDisplayer;
    private int nextIndex = 0;
    private final ProcessSlots slots = new ProcessSlots();

    public ProcessScheduler(boolean isSimTreeParent, LocalProcessSlotsOption optionLocalSlots, Options optionsRemoteSlots, SimTreeContext sc) throws SimTreeException {
        if (isSimTreeParent) {
            this.finishMessageDisplayer = new FinishMessageDisplayer(this.slots, sc);
        }
        int i = 0;
        while (i < optionsRemoteSlots.size()) {
            RemoteProcessSlotsOption option = (RemoteProcessSlotsOption)optionsRemoteSlots.get(i);
            int j = 0;
            while (j < option.getNumberOfSlots()) {
                this.slots.add(new ProcessSlot(option.getHost(), this.slots));
                ++j;
            }
            ++i;
        }
        if (optionLocalSlots != null) {
            i = 0;
            while (i < optionLocalSlots.getNumberOfSlots()) {
                this.slots.add(new ProcessSlot(this.slots));
                ++i;
            }
        }
        if (this.slots.size() == 0) {
            throw new SimTreeException("No process slot defined, use " + OptionEnum.LOCAL_PROCESS_SLOTS.longNameWithStarter + " and/or " + OptionEnum.REMOTE_PROCESS_SLOTS.longNameWithStarter);
        }
    }

    public void noMoreProcessesWillBeStarted() {
        if (this.finishMessageDisplayer != null) {
            this.finishMessageDisplayer.terminateWhenAllSlotsAreFree();
        }
    }

    private synchronized ProcessSlot getSlotSyncronized() {
        if (this.slots.size() == 0) {
            return null;
        }
        int index = this.nextIndex;
        int trials = 0;
        while (true) {
            if (index >= this.slots.size()) {
                index = 0;
            }
            if (this.slots.isFree(index)) {
                this.nextIndex = index;
                return this.slots.getSlot(index);
            }
            if (trials > this.slots.size()) {
                this.nextIndex = index;
                return null;
            }
            ++index;
            ++trials;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ProcessSlot getSlot() {
        if (ProcessScheduler.$assertionsDisabled || Thread.currentThread().getName().equals("main")) ** GOTO lbl8
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            slot = this.getSlotSyncronized();
            if (slot != null) {
                return slot;
            }
            if (this.slots.size() == 0) continue;
            Helpers.pauseThread(1000L);
lbl8:
            // 3 sources

            ** while (this.slots.size() != 0)
        }
lbl9:
        // 1 sources

        return null;
    }

    public synchronized Strings getSlotStatusStrings() {
        return this.slots.getSlotStatusStrings();
    }

    public synchronized int addLocalSlot() {
        this.slots.add(new ProcessSlot(this.slots));
        return 1;
    }

    public synchronized int addRemoteSlot(String hostName) {
        this.slots.add(new ProcessSlot(hostName, this.slots));
        return 1;
    }

    public synchronized int removeLocalSlot() {
        return this.slots.removeLocalSlot();
    }

    public synchronized int removeRemoteSlot(String hostName) {
        return this.slots.removeRemoteSlot(hostName);
    }
}

