/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.resultdef;

import ikr.simtree.base.Integers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.resultdef.ResultTypeEnum;
import ikr.simtree.resultdef.SeedDef;
import ikr.simtree.resultdef.SimulateResultDef;

public class SimulateBatchesResultDef
extends SimulateResultDef {
    public SimulateBatchesResultDef(SeedDef seedDef, Integers batchNums) {
        super(seedDef, batchNums);
    }

    public SimulateBatchesResultDef(Integers batchNums) {
        super(null, batchNums);
    }

    @Override
    public ResultTypeEnum getResultType() {
        if (this.seedDef == null) {
            return ResultTypeEnum.DEFAULT_BATCHES;
        }
        return ResultTypeEnum.SEEDED_BATCHES;
    }

    @Override
    public String getOptionArgumentString() throws SimTreeException {
        if (!this.areBatchNumsConsecutive()) {
            throw new SimTreeException("Batch Numbers are not consecutive when required");
        }
        return this.iToString(false, true);
    }

    @Override
    public String getDisplayString() {
        return this.iToString(true, true);
    }

    private String iToString(boolean acceptEmptyBatchNums, boolean emitBatchPartAsSingleNumberWhenConsecutive) {
        assert (this.getPartTestNums() != null);
        if (!acceptEmptyBatchNums) assert (this.getPartTestNums().size() != 0);
        if (emitBatchPartAsSingleNumberWhenConsecutive && this.areBatchNumsConsecutive()) {
            return String.valueOf(this.getSeedPartString(true)) + SimulateBatchesResultDef.toDisp(this.getPartTestNums().size());
        }
        String batchPart = "";
        int i = 0;
        while (i < this.getPartTestNums().size()) {
            batchPart = String.valueOf(batchPart) + SimulateBatchesResultDef.toDisp((Integer)this.getPartTestNums().get(i)) + (i < this.getPartTestNums().size() - 1 ? "," : "");
            ++i;
        }
        return String.valueOf(this.getSeedPartString(true)) + "[" + batchPart + "]";
    }

    private boolean areBatchNumsConsecutive() {
        assert (this.getPartTestNums() != null);
        int i = 0;
        while (i < this.getPartTestNums().size()) {
            if ((Integer)this.getPartTestNums().get(i) != i + 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getDisplayStringForOneRunNum(int batchNum) {
        return String.valueOf(this.getSeedPartString(true)) + "[" + SimulateBatchesResultDef.toDisp(batchNum) + "]";
    }

    @Override
    public String getResultKindString() {
        return "Batches";
    }

    @Override
    public OptionEnum getOptionEnum() {
        return OptionEnum.BATCHES;
    }
}

