/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.resultdef;

import ikr.simtree.base.Integers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.resultdef.ResultTypeEnum;
import ikr.simtree.resultdef.SeedDef;

public abstract class ResultDef {
    private final Integers partTestNums;
    protected final SeedDef seedDef;

    protected ResultDef(SeedDef seedDef, Integers partTestNums) {
        this.seedDef = seedDef;
        this.partTestNums = partTestNums;
    }

    public abstract ResultTypeEnum getResultType();

    protected static String toDisp(int i) {
        return String.format("%03d", i);
    }

    protected String getSeedPartString(boolean addSeparator) {
        return this.isDefaultBatch() ? "" : this.seedDef.toDisplayString(addSeparator);
    }

    public SeedDef getSeedDef() {
        return this.seedDef;
    }

    public boolean isDefaultBatch() {
        boolean ret;
        boolean bl = ret = this.getResultType() == ResultTypeEnum.DEFAULT_BATCHES;
        assert (ret == (this.seedDef == null));
        return ret;
    }

    public abstract String getDisplayStringForOneRunNum(int var1);

    public abstract String getResultKindString();

    public Integers getPartTestNums() {
        return this.partTestNums;
    }

    public int getPartTestCount() {
        return this.partTestNums.size();
    }

    public boolean containsPartTestNum(int partTestNum) {
        int i = 0;
        while (i < this.partTestNums.size()) {
            if ((Integer)this.partTestNums.get(i) == partTestNum) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getPartTestNumFromIndex(int i) {
        return (Integer)this.partTestNums.get(i);
    }

    public boolean containsIdenticalPartTestNums(Integers intList) {
        if (this.getPartTestCount() != intList.size()) {
            return false;
        }
        for (Integer i : intList) {
            if (this.containsPartTestNum(i)) continue;
            return false;
        }
        return true;
    }

    public abstract String getOptionArgumentString() throws SimTreeException;

    public abstract OptionEnum getOptionEnum();

    public abstract String getDisplayString();

    public String getFullDisplayString() {
        return String.valueOf(this.getResultKindString()) + " " + this.getDisplayString();
    }

    public String getFullDisplayStringWithBrackets() {
        return "[" + this.getFullDisplayString() + "]";
    }
}

