/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.query;

import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.eval.BaseParseResult;
import ikr.simtree.eval.BaseParseResultWithResultDef;
import ikr.simtree.eval.FullParseResult;
import ikr.simtree.eval.ParseResults;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.query.ParserDumpHandler;
import ikr.simtree.query.ParserHandlerConfig;
import ikr.simtree.resultdef.SingleRunResultDef;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ParserQueryHandler {
    protected final ParseResults parseResults;
    private final Matcher[] searchPathMatchers;
    private final ParserHandlerConfig parserHandlerConfig;
    private final String[] matchPatternResult = new String[Props.getInt("st.i.max_eval_printserver_depth.1")];
    private int currentMatchLevel = 0;
    private SingleRunResultDef singleRunResultDef;
    private int matchGroupIndex = -1;
    private String matchGroupValue = null;

    public ParserQueryHandler(PrintServerPath searchPath, String searchName, ParserHandlerConfig parserHandlerConfig) throws SimTreeException {
        this.parserHandlerConfig = parserHandlerConfig;
        this.parseResults = new ParseResults(searchPath, searchName);
        this.searchPathMatchers = new Matcher[searchPath.size()];
        int i = 0;
        while (i < searchPath.size()) {
            try {
                Matcher matcher;
                this.searchPathMatchers[i] = matcher = Pattern.compile((String)searchPath.get(i)).matcher("");
                if (matcher.groupCount() != 0) {
                    if (this.matchGroupIndex != -1) {
                        throw new SimTreeException("Cannot handle more than one match group in a search path");
                    }
                    this.matchGroupIndex = i;
                }
            }
            catch (PatternSyntaxException e) {
                throw new SimTreeException("Invalid regular expression " + (String)searchPath.get(i));
            }
            ++i;
        }
        if (this.matchGroupIndex != -1 && this instanceof ParserDumpHandler) {
            throw new SimTreeException("Match group not supported in dump command");
        }
    }

    protected final void addResultDep(int thisLevel, String stringFromXMLFile, String name, String value, String type) throws SimTreeException {
        if (this.isMatch(thisLevel, stringFromXMLFile)) {
            assert (this.matchGroupIndex != -1 == (this.matchGroupValue != null));
            this.addResult(name, this.matchGroupValue != null ? this.matchGroupValue : value, type);
        }
    }

    protected final void addResultDep(int thisLevel, String stringFromXMLFile, String name, String value) throws SimTreeException {
        if (this.isMatch(thisLevel, stringFromXMLFile)) {
            assert (this.matchGroupIndex != -1 == (this.matchGroupValue != null));
            this.addResult(name, this.matchGroupValue != null ? this.matchGroupValue : value);
        }
    }

    protected void addResult(String name, String value) throws SimTreeException {
        if (this.parserHandlerConfig.createBaseParseResults) {
            if (this.singleRunResultDef == null) {
                this.parseResults.add(new BaseParseResult(value));
            } else {
                this.parseResults.add(new BaseParseResultWithResultDef(value, this.singleRunResultDef));
            }
        } else {
            this.parseResults.add(new FullParseResult(this.currentMatchLevel, name, value, this.getMatchPathClone(), this.singleRunResultDef));
        }
    }

    protected void addResult(String name, String value, String type) throws SimTreeException {
        if (this.parserHandlerConfig.createBaseParseResults) {
            if (this.singleRunResultDef == null) {
                this.parseResults.add(new BaseParseResult(value));
            } else {
                this.parseResults.add(new BaseParseResultWithResultDef(value, this.singleRunResultDef));
            }
        } else {
            this.parseResults.add(new FullParseResult(this.currentMatchLevel, name, value, type, this.getMatchPathClone(), this.singleRunResultDef));
        }
    }

    protected final PrintServerPath getMatchPathClone() {
        PrintServerPath ret = new PrintServerPath();
        int i = 0;
        while (i < this.matchPatternResult.length) {
            String s = this.matchPatternResult[i];
            if (s == null) break;
            ret.add(s);
            ++i;
        }
        return ret;
    }

    private boolean isMatch(int thisLevel, String stringFromXMLFile) throws SimTreeException {
        assert (stringFromXMLFile != null);
        if (this.currentMatchLevel >= thisLevel - 1 && this.matches(thisLevel, stringFromXMLFile)) {
            if (this.currentMatchLevel + 1 == thisLevel) {
                ++this.currentMatchLevel;
            }
        } else if (thisLevel == this.currentMatchLevel) {
            --this.currentMatchLevel;
        }
        try {
            this.matchPatternResult[thisLevel] = stringFromXMLFile;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SimTreeException("Print server path too deep, increase value of property st.i.max_eval_printserver_depth.1");
        }
        if (this.parserHandlerConfig.appendWildcardToShortSearchPath) {
            return thisLevel == this.currentMatchLevel && thisLevel >= this.searchPathMatchers.length - 1;
        }
        return thisLevel == this.currentMatchLevel && thisLevel == this.searchPathMatchers.length - 1;
    }

    protected void resetMatch(int matchLevel) {
        assert (matchLevel >= 0);
        if (matchLevel <= this.matchGroupIndex) {
            this.matchGroupValue = null;
        }
        if (matchLevel == this.currentMatchLevel) {
            --this.currentMatchLevel;
        }
        this.matchPatternResult[matchLevel] = null;
    }

    private boolean matches(int matchLevel, String stringFromXMLFile) {
        if (matchLevel >= this.searchPathMatchers.length) {
            return this.parserHandlerConfig.appendWildcardToShortSearchPath;
        }
        Matcher matcher = this.searchPathMatchers[matchLevel].reset(stringFromXMLFile);
        boolean matches = matcher.matches();
        if (matches && this.matchGroupIndex == matchLevel) {
            this.matchGroupValue = matcher.group(1);
        }
        return matches;
    }

    protected void setResultDef(SingleRunResultDef singleRunResultDef) {
        this.singleRunResultDef = singleRunResultDef;
    }

    protected void parseIsComplete() {
    }
}

