/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.parafile;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.StringPairs;
import ikr.simtree.parafile.AttributeList;
import ikr.simtree.parafile.AttributesLists;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;

public abstract class ParaFileCreator {
    public static void createParaFile(String absTemplateFileName, String absTargetFileName, SimParaPath path, AttributesLists attributesLists) throws SimTreeException {
        StringPairs spList = new StringPairs();
        for (SimPara simPara : path) {
            assert (simPara.getParaName() != null);
            assert (simPara.getStringValue() != null);
            spList.add(new StringPair(simPara.getParaName(), simPara.getStringValue()));
        }
        if (attributesLists != null) {
            for (SimPara simPara : path) {
                AttributeList attributeList = attributesLists.getAttributeListForSimPara(simPara);
                if (attributeList == null) continue;
                for (StringPair attribute : attributeList.getAttributes()) {
                    for (StringPair existing : spList) {
                        if (!existing.firstStr.equals(attribute.firstStr)) continue;
                        throw new SimTreeException("Attribute with name " + existing.firstStr + " duplicates simulation parameter or other attribute");
                    }
                    spList.add(attribute);
                }
            }
        }
        Helpers.createFileFromTemplate(absTemplateFileName, absTargetFileName, spList);
    }
}

