/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphwriter.ResultPath;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.ResultPathOption;
import java.util.ArrayList;

public abstract class ResultPathOptionBase
extends Option {
    protected ResultPath resultSource;

    public ResultPathOptionBase(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    public ResultPath getResultSource() {
        assert (this.resultSource != null);
        return this.resultSource;
    }

    @Override
    protected void finalizeInit(Options optionList) throws SimTreeException {
        if (this.resultSource == null) {
            return;
        }
        ArrayList<ResultPath> rsList = new ArrayList<ResultPath>();
        Options rsOptions = optionList.getOptions(OptionEnum.COLUMN_DEFINITION);
        for (Option option : rsOptions) {
            ColumnDefinitionOption cdo = (ColumnDefinitionOption)option;
            if (cdo.getColKind() != ColumnDefinitionOption.ColKindEnum.RESULT_PATH) continue;
            rsList.add(cdo.getResultSource());
        }
        rsOptions = optionList.getOptions(OptionEnum.RESULT_PATH);
        for (Option option : rsOptions) {
            rsList.add(((ResultPathOption)option).getResultSource());
        }
        this.resultSource.expand(rsList);
    }

    @Override
    protected void finalMessage() {
        if (this.resultSource != null && this.resultSource.isWasExpanded()) {
            Message.config("Path " + this.resultSource.getResultName() + " was expanded to " + this.resultSource.getExpandedPath().toComposedString(), this.sc);
        }
    }
}

