/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.Integers;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.resultdef.ResultDefs;
import ikr.simtree.resultdef.SeedDef;
import ikr.simtree.resultdef.SimulateBatchesResultDef;
import ikr.simtree.resultdef.SimulateDropResultDef;
import java.util.Collections;

public abstract class ResultDefOption
extends Option {
    private ResultDefs resultDefs;
    private boolean isInvalidForSimulate = false;

    public ResultDefOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    public ResultDefs getResultDefs() {
        return this.resultDefs;
    }

    public boolean isInvalidForSimulate() {
        return this.isInvalidForSimulate;
    }

    @Override
    protected void parseArguments(Strings arguments) throws SimTreeException {
        if (arguments.size() == 0) {
            throw new SimTreeOptionException(this.getOptionEnum(), "At least one argument required");
        }
        this.resultDefs = new ResultDefs();
        boolean hasTwoParts = false;
        boolean hasOnePart = false;
        String err = "Can not mix definitions with and without seed";
        for (String argument : arguments) {
            String rightPart = null;
            String leftPart = null;
            if (argument.contains(":")) {
                if (hasOnePart) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Can not mix definitions with and without seed");
                }
                hasTwoParts = true;
                String[] parts = argument.split(":");
                if (parts.length != 2) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Invalid result definition in " + argument + " (only one : allowed)");
                }
                leftPart = parts[0];
                rightPart = parts[1];
            } else {
                if (hasTwoParts) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Can not mix definitions with and without seed");
                }
                hasOnePart = true;
                rightPart = argument;
            }
            assert (rightPart != null);
            ParseListResult rightListResult = this.parseList(rightPart, true);
            assert (rightListResult.list.size() > 0);
            if (this.optionEnum == OptionEnum.BATCHES) {
                if (rightListResult.wasGivenAsList) {
                    this.isInvalidForSimulate = true;
                }
                if (leftPart == null) {
                    this.resultDefs.addResultDef(new SimulateBatchesResultDef(rightListResult.list));
                    continue;
                }
                for (Integer seed : this.parseList((String)leftPart, (boolean)false).list) {
                    if (seed < 0) {
                        throw new SimTreeOptionException(this.getOptionEnum(), "Invalid seed number in " + argument + ", seed must be >= 0");
                    }
                    if (seed > Props.getInt("st.i.max_seed_index.1")) {
                        throw new SimTreeOptionException(this.getOptionEnum(), "Invalid seed number in " + argument + ", seed must <= " + Props.getInt("st.i.max_seed_index.1") + ", see Property + " + "st.i.max_seed_index.1");
                    }
                    this.resultDefs.addResultDef(new SimulateBatchesResultDef(new SeedDef(seed), rightListResult.list.clone()));
                }
                continue;
            }
            if (leftPart != null) {
                throw new SimTreeOptionException(this.getOptionEnum(), "Invalid drop definition, must only contain one part and no :");
            }
            for (Integer seed : rightListResult.list) {
                if (seed < 0) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Invalid seed number in " + argument + ", seed must be >= 0");
                }
                if (seed > Props.getInt("st.i.max_seed_index.1")) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Invalid seed number in " + argument + ", seed must <= " + Props.getInt("st.i.max_seed_index.1") + ", see Property + " + "st.i.max_seed_index.1");
                }
                this.resultDefs.addResultDef(new SimulateDropResultDef(new SeedDef(seed)));
            }
        }
    }

    private ParseListResult parseList(String list, boolean convertSingleNumberToList) throws SimTreeException {
        assert (list.length() != 0);
        ParseListResult parseResultList = new ParseListResult();
        if (!list.contains("[")) {
            int i = -1;
            try {
                i = new Integer(list);
            }
            catch (NumberFormatException e) {
                throw new SimTreeOptionException(this.getOptionEnum(), "Invalid value in " + list + ", must be a non negative integer value");
            }
            if (convertSingleNumberToList) {
                if (i <= 0) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Number must be a positive integer quantity (not " + list + ")");
                }
                int c = 1;
                while (c < i + 1) {
                    parseResultList.list.add(new Integer(c));
                    ++c;
                }
            } else {
                if (i < 0) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Value must be a non negative integer number (not " + list + ")");
                }
                parseResultList.list.add(new Integer(i));
            }
        } else {
            if (!list.startsWith("[") || !list.endsWith("]")) {
                throw new SimTreeOptionException(this.getOptionEnum(), "Invalid list, must begin with [ and end with ]");
            }
            String[] listRangeArr = list.substring(1, list.length() - 1).split(",");
            parseResultList.wasGivenAsList = true;
            String[] stringArray = listRangeArr;
            int n = listRangeArr.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                if (range.contains("-")) {
                    String[] sp = range.split("-");
                    if (sp.length != 2) {
                        throw new SimTreeOptionException(this.getOptionEnum(), "Invalid range " + range + " in " + list);
                    }
                    int from = 0;
                    int to = 0;
                    try {
                        from = new Integer(sp[0]);
                        to = new Integer(sp[1]);
                    }
                    catch (NumberFormatException i) {
                        throw new SimTreeOptionException(this.getOptionEnum(), "Invalid number in range " + range);
                    }
                    if (from > to) {
                        throw new SimTreeOptionException(this.getOptionEnum(), "Invalid range " + range + ", first value larger than second value");
                    }
                    int l = from;
                    while (l <= to) {
                        parseResultList.list.add(new Integer(l));
                        ++l;
                    }
                } else {
                    parseResultList.list.add(new Integer(range));
                }
                ++n2;
            }
            if (parseResultList.list.size() == 0) {
                throw new SimTreeOptionException(this.getOptionEnum(), "At least one number required in " + list);
            }
            Collections.sort(parseResultList.list);
            int i = 0;
            while (i < parseResultList.list.size() - 1) {
                if (((Integer)parseResultList.list.get(i)).intValue() == ((Integer)parseResultList.list.get(i + 1)).intValue()) {
                    throw new SimTreeOptionException(this.getOptionEnum(), "Double number in " + list);
                }
                ++i;
            }
        }
        return parseResultList;
    }

    private static class ParseListResult {
        public final Integers list = new Integers();
        public boolean wasGivenAsList = false;

        private ParseListResult() {
        }
    }
}

