/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;

public class RemoteProcessSlotsOption
extends Option {
    private String host;
    private int count;

    public RemoteProcessSlotsOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    @Override
    protected void parseArguments(Strings arguments) throws SimTreeException {
        this.checkArgumentCount(2);
        this.host = (String)arguments.get(0);
        this.count = this.numericArgument(1);
        if (this.count < 0) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Count must be greater or equal zero");
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getNumberOfSlots() {
        return this.count;
    }

    @Override
    protected void checkDependencies(Options options, CommandEnum commandEnum) throws SimTreeException {
        this.conflictWhenFirstArgEqual(options);
    }
}

