/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.commandline.UnparsedOption;
import ikr.simtree.commandline.UnparsedOptions;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.BatchesOption;
import ikr.simtree.options.BoolOption;
import ikr.simtree.options.DropsOption;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionFactory;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.ResultDefOption;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.vfs.results.node.SimulationMethodEnum;
import ikr.simtree.vfs.results.tree.ResultsTreeState;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class Options
extends ArrayList<Option> {
    private final SimTreeContext sc;

    public Options(SimTreeContext sc) {
        this.sc = sc;
    }

    public void merge(File optionsFile, OptionSourceEnum source) throws SimTreeException {
        this.merge(Helpers.readOptionFile(optionsFile, source, this.sc));
    }

    private static boolean hasSourcePrecedence(Option newOption, Option oldOption) {
        return newOption.getSource() == OptionSourceEnum.COMMAND_LINE || newOption.getSource() == OptionSourceEnum.CUSTOM_CONFIG_FILE && oldOption.getSource() == OptionSourceEnum.DEFAULT_CONFIG_FILE || oldOption.getSource() == OptionSourceEnum.GENERATED_DEFAULT;
    }

    public void merge(Options newOptions) throws SimTreeException {
        if (newOptions.size() == 0) {
            return;
        }
        Options addOptions = new Options(this.sc);
        for (Option newOption : newOptions) {
            boolean handled = false;
            int o = 0;
            while (o < this.size()) {
                Option oldOption = (Option)this.get(o);
                assert (oldOption.getMergeMode() != null);
                if (!handled && oldOption.getOptionEnum() == newOption.getOptionEnum()) {
                    boolean ignored;
                    handled = true;
                    switch (oldOption.getMergeMode()) {
                        case IGNORE: {
                            ignored = true;
                            break;
                        }
                        case ADD: {
                            ignored = false;
                            addOptions.add(newOption);
                            break;
                        }
                        case CONFLICT: {
                            ignored = true;
                            throw new SimTreeOptionException(oldOption.getOptionEnum(), "Cannot replace existing option");
                        }
                        case REPLACE: {
                            ignored = true;
                            if (!Options.hasSourcePrecedence(newOption, oldOption)) break;
                            this.set(o, newOption);
                            ignored = false;
                            break;
                        }
                        case REPLACE_WHEN_1ARG_EQUAL_ELSE_IGNORE: {
                            ignored = true;
                            if (!newOption.isFirstArgEqual(oldOption) || !Options.hasSourcePrecedence(newOption, oldOption)) break;
                            this.set(o, newOption);
                            ignored = false;
                            break;
                        }
                        case REPLACE_WHEN_1ARG_EQUAL_ELSE_ADD: {
                            ignored = true;
                            if (newOption.isFirstArgEqual(oldOption)) {
                                if (!Options.hasSourcePrecedence(newOption, oldOption)) break;
                                this.set(o, newOption);
                                ignored = false;
                                break;
                            }
                            addOptions.add(newOption);
                            ignored = false;
                            break;
                        }
                        default: {
                            ignored = true;
                            assert (false);
                            break;
                        }
                    }
                    if (ignored) {
                        Message.config(Options.getOptionConfigMessage(newOption, true), this.sc);
                    }
                }
                ++o;
            }
            if (handled) continue;
            addOptions.add(newOption);
        }
        for (Option option : addOptions) {
            this.add(option);
        }
    }

    private void mergeDefaults() throws SimTreeException {
        Options newOptions = new Options(this.sc);
        OptionEnum[] optionEnumArray = OptionEnum.values();
        int n = optionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option defaultOption;
            OptionEnum optionEnum = optionEnumArray[n2];
            Option o = OptionFactory.create(optionEnum.longName, null, OptionSourceEnum.GENERATED_DEFAULT, this.sc);
            if (o != null && (defaultOption = o.createDefault()) != null) {
                newOptions.add(defaultOption);
            }
            ++n2;
        }
        this.merge(newOptions);
    }

    private void modifyOptions(CommandEnum commandEnum) throws SimTreeException {
        boolean modified;
        block0: do {
            modified = false;
            for (Option option : this) {
                if (!option.modifyOptions(this, commandEnum)) continue;
                modified = true;
                continue block0;
            }
        } while (modified);
    }

    public void checkAndModifyOptionsForCommand(CommandEnum commandEnum) throws SimTreeException {
        OptionEnum[] alwaysValidOptions = CommandEnum.alwaysValidOptions;
        OptionEnum[] validOptions = commandEnum.validOptions;
        OptionEnum[] requiredOptions = commandEnum.requiredOptions;
        assert (commandEnum != null);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            OptionEnum element;
            Option option = (Option)iter.next();
            boolean found = false;
            OptionEnum optionEnum = option.getOptionEnum();
            OptionEnum[] optionEnumArray = validOptions;
            int n = validOptions.length;
            int n2 = 0;
            while (n2 < n) {
                element = optionEnumArray[n2];
                if (optionEnum == element) {
                    found = true;
                }
                ++n2;
            }
            if (!found) {
                optionEnumArray = alwaysValidOptions;
                n = alwaysValidOptions.length;
                n2 = 0;
                while (n2 < n) {
                    element = optionEnumArray[n2];
                    if (optionEnum == element) {
                        found = true;
                    }
                    ++n2;
                }
            }
            if (!found) {
                optionEnumArray = requiredOptions;
                n = requiredOptions.length;
                n2 = 0;
                while (n2 < n) {
                    element = optionEnumArray[n2];
                    if (optionEnum == element) {
                        found = true;
                    }
                    ++n2;
                }
            }
            if (!found) {
                optionEnumArray = commandEnum.requiredOneOfOptions;
                n = commandEnum.requiredOneOfOptions.length;
                n2 = 0;
                while (n2 < n) {
                    OptionEnum oo;
                    OptionEnum optionEnum2 = oo = optionEnumArray[n2];
                    int n3 = ((OptionEnum)optionEnum2).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        OptionEnum element2 = optionEnum2[n4];
                        if (optionEnum == element2) {
                            found = true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            if (found) continue;
            if (option.getSource() == OptionSourceEnum.COMMAND_LINE) {
                throw new SimTreeOptionException(optionEnum, "Option not allowed for command " + commandEnum.commandName);
            }
            if (option.getSource() != OptionSourceEnum.DEFAULT_CONFIG_FILE && option.getSource() != OptionSourceEnum.GENERATED_DEFAULT) continue;
            if (option.getSource() != OptionSourceEnum.GENERATED_DEFAULT) {
                Message.config(Options.getOptionConfigMessage(option, true), this.sc);
            }
            iter.remove();
        }
        OptionEnum[] optionEnumArray = requiredOptions;
        int n = requiredOptions.length;
        int n5 = 0;
        while (n5 < n) {
            OptionEnum element = optionEnumArray[n5];
            if (this.getOptions(element).size() == 0) {
                throw new SimTreeOptionException(element, "Option required for command " + commandEnum.commandName);
            }
            ++n5;
        }
        optionEnumArray = commandEnum.requiredOneOfOptions;
        n = commandEnum.requiredOneOfOptions.length;
        n5 = 0;
        while (n5 < n) {
            OptionEnum oo = optionEnumArray[n5];
            boolean found = false;
            OptionEnum optionEnum = oo;
            int n6 = ((OptionEnum)optionEnum).length;
            int n7 = 0;
            while (n7 < n6) {
                OptionEnum o = optionEnum[n7];
                if (this.getOptions(o).size() != 0) {
                    found = true;
                }
                ++n7;
            }
            if (!found) {
                String oList = "";
                OptionEnum optionEnum3 = oo;
                int n8 = ((OptionEnum)optionEnum3).length;
                n6 = 0;
                while (n6 < n8) {
                    OptionEnum o = optionEnum3[n6];
                    oList = String.valueOf(oList) + o.hlp10;
                    ++n6;
                }
                throw new SimTreeException("One of the options" + oList + " is required for command " + commandEnum.commandName);
            }
            ++n5;
        }
    }

    private static String getOptionConfigMessage(Option option, boolean ignored) {
        return String.valueOf(SHelpers.indent(1)) + "(" + option.getSource().displayName + ") " + (ignored ? "ignored " : "") + option.createCommandlineString();
    }

    private int numOptionGiven(OptionEnum optionEnum) {
        return this.getOptions(optionEnum).size();
    }

    public Options getOptions(OptionEnum optionEnum) {
        Options ret = new Options(this.sc);
        for (Option option : this) {
            if (option.getOptionEnum() != optionEnum) continue;
            ret.add(option);
        }
        return ret;
    }

    public boolean isSimTreeParent() {
        return !this.isBoolOptionSet(OptionEnum.CHILD);
    }

    public boolean isBoolOptionSet(OptionEnum optionEnum) {
        return (BoolOption)this.getOption(optionEnum) != null;
    }

    public Option getOption(OptionEnum optionEnum) {
        assert (this.numOptionGiven(optionEnum) <= 1);
        for (Option option : this) {
            if (option.getOptionEnum() != optionEnum) continue;
            return option;
        }
        return null;
    }

    private Strings getCurrentConfig() {
        Strings ret = new Strings();
        if (this.size() != 0) {
            ret.add("Using the following merged options");
        }
        for (Option option : this) {
            ret.add(Options.getOptionConfigMessage(option, false));
        }
        return ret;
    }

    public static Options fromUnparsedOptions(UnparsedOptions unparsedOptions, OptionSourceEnum optionSourceEnum, SimTreeContext sc) throws SimTreeException {
        Options ret = new Options(sc);
        for (UnparsedOption unparsedOption : unparsedOptions) {
            Option o = OptionFactory.create(unparsedOption.optionName, unparsedOption.arguments, optionSourceEnum, sc);
            if (o == null) continue;
            ret.add(o);
        }
        return ret;
    }

    public static Options handle(Options commandLineOptions, CommandEnum commandEnum, SimTreeContext sc) throws SimTreeException {
        Options options = new Options(sc);
        options.mergeDefaults();
        if (!commandLineOptions.isBoolOptionSet(OptionEnum.IGNORE_DEFAULT_CONFIG)) {
            options.merge(new File(StudyRootVFS.getDefaultConfigFileName()), OptionSourceEnum.DEFAULT_CONFIG_FILE);
        }
        options.merge(commandLineOptions);
        options.modifyOptions(commandEnum);
        for (Option option : options) {
            option.checkDependencies(options, commandEnum);
        }
        options.checkAndModifyOptionsForCommand(commandEnum);
        for (Option option : options) {
            option.finalizeInit(options);
        }
        for (String str : options.getCurrentConfig()) {
            Message.config(str, sc);
        }
        for (Option option : options) {
            option.finalMessage();
        }
        return options;
    }

    public String toCommandLine() {
        String ret = "";
        for (Option o : this) {
            ret = String.valueOf(ret) + " " + o.createCommandlineString();
        }
        return ret;
    }

    public ResultDefOption getCheckedResultDefOption(CommandEnum commandEnum) throws SimTreeException {
        assert (commandEnum != null);
        BatchesOption batchesOption = (BatchesOption)this.getOption(OptionEnum.BATCHES);
        DropsOption dropsOption = (DropsOption)this.getOption(OptionEnum.DROPS);
        if (batchesOption != null && dropsOption != null) {
            throw new SimTreeException("Only one of the options" + OptionEnum.DROPS.hlp11 + "and" + OptionEnum.BATCHES.hlp11 + "is allowed");
        }
        switch (commandEnum) {
            case SIMULATE: {
                break;
            }
            case COLLECT: {
                if (batchesOption == null && dropsOption == null) break;
                throw new SimTreeException("Result definition not allowed for collect");
            }
        }
        if (ResultsTreeState.getSimulationMethod(false, this.sc) == SimulationMethodEnum.BATCH_MEAN && dropsOption != null) {
            throw new SimTreeException("Invalid option" + OptionEnum.DROPS.hlp11 + "for simulation method " + SimulationMethodEnum.BATCH_MEAN.readableName);
        }
        if (ResultsTreeState.getSimulationMethod(false, this.sc) == SimulationMethodEnum.INDEPENDENT_REPLICATION && batchesOption != null) {
            throw new SimTreeException("Invalid option" + OptionEnum.BATCHES.hlp11 + "for simulation method " + SimulationMethodEnum.INDEPENDENT_REPLICATION.readableName);
        }
        ResultDefOption ret = batchesOption != null ? batchesOption : dropsOption;
        if (commandEnum == CommandEnum.SIMULATE && ret != null && ret.isInvalidForSimulate()) {
            throw new SimTreeException("For simulate, lists are not allowed to specify the number of results");
        }
        return ret;
    }
}

