/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.EnumHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.commandline.UnparsedOption;
import ikr.simtree.commandline.UnparsedOptions;
import ikr.simtree.help.CrossRef;
import ikr.simtree.help.CrossRefEnum;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.HelpTextExtractor;
import ikr.simtree.help.SimpleHelpPara;
import ikr.simtree.help.TwoColHelpPara;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionGroupEnum;
import java.util.ArrayList;
import java.util.List;

public final class OptionEnum
extends Enum<OptionEnum> {
    public static final /* enum */ OptionEnum HELP = new OptionEnum(OptionGroupEnum.INFO, Option.MergeModeEnum.IGNORE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum STUDY_ROOT = new OptionEnum(OptionGroupEnum.SIMPARAVALUESET, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum SIMULATION_PARAMETER_PATH = new OptionEnum(OptionGroupEnum.SIMPARAVALUESET, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum SIMULATION_PARAMETER = new OptionEnum(OptionGroupEnum.SIMPARAVALUESET, Option.MergeModeEnum.ADD, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum REMOTE_PROCESS_SLOTS = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE_WHEN_1ARG_EQUAL_ELSE_ADD, Option.SaveTargetEnum.CUSTOM_CONFIG_FILE_ONLY, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum LOCAL_PROCESS_SLOTS = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.CUSTOM_CONFIG_FILE_ONLY, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum BATCHES = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.CUSTOM_CONFIG_FILE_ONLY, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum DROPS = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.CUSTOM_CONFIG_FILE_ONLY, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum SIMULATION_BINARY = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum PARAMETER_FILE_TEMPLATE = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum FILTER_FILE = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum RESULT_PATH = new OptionEnum(OptionGroupEnum.EVAL, Option.MergeModeEnum.REPLACE_WHEN_1ARG_EQUAL_ELSE_ADD, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum IGNORE_DEFAULT_CONFIG = new OptionEnum(OptionGroupEnum.CONFIG, Option.MergeModeEnum.IGNORE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum COLUMN_DEFINITION = new OptionEnum(OptionGroupEnum.EVAL, Option.MergeModeEnum.REPLACE_WHEN_1ARG_EQUAL_ELSE_ADD, Option.SaveTargetEnum.CUSTOM_CONFIG_FILE_ONLY, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum GRAPH_WRITER = new OptionEnum(OptionGroupEnum.EVAL, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum SAVE_CONFIG = new OptionEnum(OptionGroupEnum.CONFIG, Option.MergeModeEnum.CONFLICT, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum REPLACE_CONFIG = new OptionEnum(OptionGroupEnum.CONFIG, Option.MergeModeEnum.CONFLICT, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum LOAD_CONFIG = new OptionEnum(OptionGroupEnum.CONFIG, Option.MergeModeEnum.ADD, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum FORCE_ALL_VALUES = new OptionEnum(OptionGroupEnum.SIMPARAVALUESET, Option.MergeModeEnum.IGNORE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum FORCE_DELETE_FOREIGN_FILES = new OptionEnum(OptionGroupEnum.SIMPARAVALUESET, Option.MergeModeEnum.IGNORE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum PRINT_FORMAT = new OptionEnum(OptionGroupEnum.INFO, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum VERY_VERBOSE = new OptionEnum(OptionGroupEnum.INFO, Option.MergeModeEnum.IGNORE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum VERBOSE = new OptionEnum(OptionGroupEnum.INFO, Option.MergeModeEnum.IGNORE, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum CONTROL_COMMAND = new OptionEnum(OptionGroupEnum.MANAGEMENT, Option.MergeModeEnum.CONFLICT, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER);
    public static final /* enum */ OptionEnum MAX_DEPTH = new OptionEnum(OptionGroupEnum.EVAL, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS);
    public static final /* enum */ OptionEnum WORKING_DIRECTORY = new OptionEnum(OptionGroupEnum.INTERNAL, Option.MergeModeEnum.CONFLICT, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER, false);
    public static final /* enum */ OptionEnum CHILD = new OptionEnum(OptionGroupEnum.INTERNAL, Option.MergeModeEnum.CONFLICT, Option.SaveTargetEnum.NA, Option.SaveConditionEnum.NEVER, false);
    public static final /* enum */ OptionEnum RESULT_FILE_NAME = new OptionEnum(OptionGroupEnum.SIMULATE, Option.MergeModeEnum.REPLACE, Option.SaveTargetEnum.ANY_CONFIG_FILE, Option.SaveConditionEnum.ALWAYS, false);
    public final String longName;
    public final String longNameWithStarter;
    public final boolean isVisible;
    public final String shortName;
    public final String shortNameWithStarter;
    public final String hlp11;
    public final String hlp10;
    public final Option.MergeModeEnum mergeMode;
    public final Option.SaveTargetEnum saveTarget;
    public final Option.SaveConditionEnum saveCondition;
    public final OptionGroupEnum optionGroupEnum;
    private static final /* synthetic */ OptionEnum[] ENUM$VALUES;

    static {
        ENUM$VALUES = new OptionEnum[]{HELP, STUDY_ROOT, SIMULATION_PARAMETER_PATH, SIMULATION_PARAMETER, REMOTE_PROCESS_SLOTS, LOCAL_PROCESS_SLOTS, BATCHES, DROPS, SIMULATION_BINARY, PARAMETER_FILE_TEMPLATE, FILTER_FILE, RESULT_PATH, IGNORE_DEFAULT_CONFIG, COLUMN_DEFINITION, GRAPH_WRITER, SAVE_CONFIG, REPLACE_CONFIG, LOAD_CONFIG, FORCE_ALL_VALUES, FORCE_DELETE_FOREIGN_FILES, PRINT_FORMAT, VERY_VERBOSE, VERBOSE, CONTROL_COMMAND, MAX_DEPTH, WORKING_DIRECTORY, CHILD, RESULT_FILE_NAME};
    }

    private OptionEnum(OptionGroupEnum optionGroupEnum, Option.MergeModeEnum mergeMode, Option.SaveTargetEnum saveTarget, Option.SaveConditionEnum saveCondition, boolean visible) {
        this.isVisible = visible;
        this.longName = EnumHelpers.enumLongName(this);
        this.shortName = EnumHelpers.enumShortName(this);
        this.mergeMode = mergeMode;
        this.saveCondition = saveCondition;
        this.saveTarget = saveTarget;
        this.optionGroupEnum = optionGroupEnum;
        if (saveCondition == Option.SaveConditionEnum.NEVER) assert (saveTarget == Option.SaveTargetEnum.NA);
        this.longNameWithStarter = "--" + this.longName;
        this.shortNameWithStarter = "--" + this.shortName;
        this.hlp11 = " " + this.longNameWithStarter + " ";
        this.hlp10 = " " + this.longNameWithStarter;
    }

    private OptionEnum(OptionGroupEnum optionGroupEnum, Option.MergeModeEnum mergeMode, Option.SaveTargetEnum saveTarget, Option.SaveConditionEnum saveCondition) {
        this(optionGroupEnum, mergeMode, saveTarget, saveCondition, true);
    }

    public boolean match(String givenName) {
        return EnumHelpers.matches(givenName, this);
    }

    public static OptionEnum getOptionEnumFromName(String name) {
        OptionEnum[] optionEnumArray = OptionEnum.values();
        int n = optionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptionEnum optionEnum = optionEnumArray[n2];
            if (EnumHelpers.matches(name, optionEnum)) {
                return optionEnum;
            }
            ++n2;
        }
        return null;
    }

    public static HelpPara getShortHelpForOptionList(List<OptionEnum> options, int indent) throws SimTreeException {
        TwoColHelpPara ret = new TwoColHelpPara(HelpParaTypeEnum.E0, indent, 26);
        for (OptionEnum optionEnum : options) {
            ret.addLine(new StringPair("[@o]" + optionEnum.longNameWithStarter + "," + "[@o]" + optionEnum.shortNameWithStarter, HelpTextExtractor.getHelpTextLine("options", optionEnum.longName, "short")));
        }
        return ret;
    }

    public static HelpPara getShortHelpForOptionArray(OptionEnum[] options, int indent) throws SimTreeException {
        ArrayList<OptionEnum> optionList = new ArrayList<OptionEnum>();
        OptionEnum[] optionEnumArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            OptionEnum e = optionEnumArray[n2];
            optionList.add(e);
            ++n2;
        }
        return OptionEnum.getShortHelpForOptionList(optionList, indent);
    }

    public static HelpParas getAllListHelp(int indent) throws SimTreeException {
        HelpParas ret = new HelpParas();
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, "The following options are defined"));
        ret.addGapAfter();
        OptionGroupEnum[] optionGroupEnumArray = OptionGroupEnum.values();
        int n = optionGroupEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptionGroupEnum optionGroup = optionGroupEnumArray[n2];
            if (optionGroup != OptionGroupEnum.INTERNAL) {
                ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent + 1, optionGroup.helpText));
                TwoColHelpPara helpPara = new TwoColHelpPara(HelpParaTypeEnum.E0, indent + 2, 26);
                OptionEnum[] optionEnumArray = OptionEnum.values();
                int n3 = optionEnumArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    OptionEnum option = optionEnumArray[n4];
                    if (option.optionGroupEnum == optionGroup) {
                        helpPara.addLine(new StringPair(String.valueOf(CrossRefEnum.OPTION.tag) + option.longNameWithStarter, HelpTextExtractor.getHelpTextLine("options", option.longName, "short")));
                    }
                    ++n4;
                }
                ret.add(helpPara);
                ret.addGapAfter();
            }
            ++n2;
        }
        ret.addGapAfter();
        return ret;
    }

    public HelpParas getFullHelp(int indent) throws SimTreeException {
        HelpParas helpParas = new HelpParas();
        helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, "Summary"));
        ArrayList<OptionEnum> oList = new ArrayList<OptionEnum>();
        oList.add(this);
        helpParas.add(OptionEnum.getShortHelpForOptionList(oList, indent + 1));
        helpParas.addGapAfter();
        helpParas.addAll(HelpTextExtractor.getHelpSectionParas(indent, "Syntax", "options", this.longName, "syntax"));
        helpParas.addAll(HelpTextExtractor.getHelpSectionParas(indent, "Description", "options", this.longName, "desc"));
        helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, "When using the" + OptionEnum.SAVE_CONFIG.hlp11 + "or" + OptionEnum.REPLACE_CONFIG.hlp11 + "option"));
        String targetStr = "";
        switch (this.saveTarget) {
            case GLOBAL_CONFIG_FILE_ONLY: {
                targetStr = "but only in the global (unnamed) config file";
                break;
            }
            case CUSTOM_CONFIG_FILE_ONLY: {
                targetStr = "but only in a named config file (not the global config file)";
                break;
            }
            case ANY_CONFIG_FILE: {
                targetStr = "and saved in any kind of config file";
                break;
            }
        }
        switch (this.saveCondition) {
            case ALWAYS: {
                helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.E1, indent, "this option is always saved " + targetStr));
                break;
            }
            case WHEN_FROM_COMMANDLINE_ONLY: {
                helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.E1, indent, "this option is saved when given on the command line " + targetStr));
                break;
            }
            case NEVER: {
                helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.E1, indent, "this option is never saved"));
            }
        }
        helpParas.addGapAfter();
        helpParas.addAll(HelpTextExtractor.getHelpSectionParas(indent, "Examples", "options", this.longName, "examples"));
        helpParas.addAll(HelpTextExtractor.getHelpSectionParas(indent, "Hints", "options", this.longName, "hints"));
        return helpParas;
    }

    public static boolean isConsistent() {
        OptionEnum[] optionEnumArray = OptionEnum.values();
        int n = optionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptionEnum option1 = optionEnumArray[n2];
            OptionEnum[] optionEnumArray2 = OptionEnum.values();
            int n3 = optionEnumArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                OptionEnum option2 = optionEnumArray2[n4];
                if (option1 != option2 && option1.shortName.equals(option2.shortName)) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public static OptionEnum fromUnparsedOption(UnparsedOption unparsedOption) {
        OptionEnum[] optionEnumArray = OptionEnum.values();
        int n = optionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptionEnum optionEnum = optionEnumArray[n2];
            if (optionEnum.match(unparsedOption.optionName)) {
                return optionEnum;
            }
            ++n2;
        }
        return null;
    }

    public UnparsedOptions fromUnparsedOptions(UnparsedOptions unparsedOptions) {
        UnparsedOptions ret = new UnparsedOptions();
        for (UnparsedOption unparsedOption : unparsedOptions) {
            if (!this.match(unparsedOption.optionName)) continue;
            ret.add(unparsedOption);
        }
        return ret;
    }

    public CrossRef getCrossRef() {
        return new CrossRef(CrossRefEnum.OPTION, this.shortName);
    }

    private static String replaceOneOptionCrossRef(OptionEnum optionEnum, String line, String optionText) {
        return line.replaceAll("\\Q" + CrossRefEnum.OPTION.tag + optionText + "\\E", String.valueOf(optionEnum.getCrossRef().toHTMLRefStart()) + optionText + CrossRef.toHTMLRefEnd());
    }

    public static String replaceXrefMarks(String line) throws SimTreeException {
        String ret = line;
        if (ret.contains(CrossRefEnum.OPTION.tag)) {
            OptionEnum optionEnum;
            OptionEnum[] optionEnumArray = OptionEnum.values();
            int n = optionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                optionEnum = optionEnumArray[n2];
                ret = OptionEnum.replaceOneOptionCrossRef(optionEnum, ret, optionEnum.longNameWithStarter);
                ret = OptionEnum.replaceOneOptionCrossRef(optionEnum, ret, optionEnum.longName);
                ++n2;
            }
            optionEnumArray = OptionEnum.values();
            n = optionEnumArray.length;
            n2 = 0;
            while (n2 < n) {
                optionEnum = optionEnumArray[n2];
                ret = OptionEnum.replaceOneOptionCrossRef(optionEnum, ret, optionEnum.shortName);
                ret = OptionEnum.replaceOneOptionCrossRef(optionEnum, ret, optionEnum.shortNameWithStarter);
                ++n2;
            }
            if (ret.contains(CrossRefEnum.OPTION.tag)) {
                throw new SimTreeException("Invalid cross reference in help string [" + line + "]");
            }
        }
        return ret;
    }

    public static OptionEnum[] values() {
        OptionEnum[] optionEnumArray = ENUM$VALUES;
        int n = optionEnumArray.length;
        OptionEnum[] optionEnumArray2 = new OptionEnum[n];
        System.arraycopy(ENUM$VALUES, 0, optionEnumArray2, 0, n);
        return optionEnumArray2;
    }

    public static OptionEnum valueOf(String string) {
        return Enum.valueOf(OptionEnum.class, string);
    }
}

