/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.EnumHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.graphwriter.GraphWriterEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;

public class GraphWriterOption
extends Option {
    private GraphWriterEnum graphWriterEnum;
    private String[] additionalArguments = null;

    public GraphWriterOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    @Override
    protected void parseArguments(Strings arguments) throws SimTreeOptionException {
        if (arguments.size() == 0) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Need at least one option Argument");
        }
        String arg = ((String)arguments.get(0)).toLowerCase();
        this.graphWriterEnum = null;
        GraphWriterEnum[] graphWriterEnumArray = GraphWriterEnum.values();
        int n = graphWriterEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphWriterEnum f = graphWriterEnumArray[n2];
            if (EnumHelpers.matches(arg, f)) {
                this.graphWriterEnum = f;
            }
            ++n2;
        }
        if (this.graphWriterEnum == null) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Invalid or non-existing graph writer");
        }
        this.replaceArgument(0, this.graphWriterEnum.longName);
        if (arguments.size() > 1) {
            this.additionalArguments = new String[arguments.size() - 1];
            int i = 1;
            while (i < arguments.size()) {
                this.additionalArguments[i - 1] = (String)arguments.get(i);
                ++i;
            }
        }
    }

    @Override
    protected Option createDefault() throws SimTreeException {
        GraphWriterOption o = new GraphWriterOption(OptionEnum.GRAPH_WRITER, OptionSourceEnum.GENERATED_DEFAULT, this.sc);
        o.setAndParseArguments(GraphWriterOption.makeArgumentsFromString(GraphWriterEnum.FLAT.longName));
        return o;
    }

    public GraphWriterEnum getGraphWriterEnum() {
        assert (this.graphWriterEnum != null);
        return this.graphWriterEnum;
    }

    public String[] getAdditionalArguments() {
        return this.additionalArguments;
    }

    @Override
    protected void checkDependencies(Options options, CommandEnum commandEnum) throws SimTreeException {
        this.checkOnlyOnce(options);
    }
}

