/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.EnumHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.graphwriter.ResultPath;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.ResultPathOptionBase;

public class ColumnDefinitionOption
extends ResultPathOptionBase {
    private int colNum;
    private ColKindEnum colKindEnum;
    private String arg;

    public ColumnDefinitionOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    @Override
    protected void parseArguments(Strings arguments) throws SimTreeException {
        this.checkArgumentCondition(arguments.size() >= 2);
        this.colNum = this.numericArgument(0);
        String ks = (String)arguments.get(1);
        ColKindEnum[] colKindEnumArray = ColKindEnum.values();
        int n = colKindEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColKindEnum k = colKindEnumArray[n2];
            if (EnumHelpers.matches(ks, k)) {
                this.colKindEnum = k;
            }
            ++n2;
        }
        if (this.colKindEnum == null) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Invalid column type " + ks);
        }
        this.checkArgumentCount(this.colKindEnum.paraNum);
        this.replaceArgument(1, this.colKindEnum.longName);
        if (this.colKindEnum.paraNum > 2) {
            this.arg = (String)arguments.get(2);
        }
        if (this.colKindEnum == ColKindEnum.RESULT_PATH) {
            this.resultSource = new ResultPath(this.getColSearchName(), new PrintServerPath(this.arg));
        }
    }

    public int getColNum() {
        return this.colNum;
    }

    public ColKindEnum getColKind() {
        return this.colKindEnum;
    }

    public String getColArg() {
        return this.arg;
    }

    public String getColSearchName() {
        return "Col" + this.getColNum();
    }

    @Override
    public ResultPath getResultSource() {
        assert (this.colKindEnum == ColKindEnum.RESULT_PATH);
        return super.getResultSource();
    }

    public String getParaName() {
        assert (this.colKindEnum == ColKindEnum.SIMULATION_PARAMETER);
        return this.arg;
    }

    @Override
    protected void checkDependencies(Options options, CommandEnum commandEnum) throws SimTreeException {
        this.conflictWhenFirstArgEqual(options);
        if (this.colKindEnum == ColKindEnum.BATCH_NUMBER) {
            this.requiresOption(options, OptionEnum.BATCHES);
        } else if (this.colKindEnum == ColKindEnum.DROP_NUMBER) {
            this.requiresOption(options, OptionEnum.DROPS);
        }
    }

    public static enum ColKindEnum {
        SIMULATION_PARAMETER(3),
        RESULT_PATH(3),
        BATCH_NUMBER(2),
        DROP_NUMBER(2);

        public final String longName = EnumHelpers.enumLongName(this);
        public final int paraNum;

        private ColKindEnum(int paraNum) {
            this.paraNum = paraNum;
        }
    }
}

