/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.launch;

import ikr.simtree.SimTree;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.commandline.UnparsedOption;
import ikr.simtree.commandline.UnparsedOptions;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.vfs.StudyRootVFS;

public class SimTreeLauncher {
    private final UnparsedOptions unparsedOptions = new UnparsedOptions();
    private final SimTreeContext sc = new SimTreeContext();
    private final CommandDesc commandDesc;

    public SimTreeLauncher(CommandDesc commandDesc) {
        this.commandDesc = commandDesc;
        this.sc.setCurrentCommand(commandDesc.commandEnum);
        this.addOption(OptionEnum.STUDY_ROOT, StudyRootVFS.getStudyRoot());
        this.addOption(OptionEnum.IGNORE_DEFAULT_CONFIG);
    }

    public void addOption(OptionEnum optionEnum) {
        this.unparsedOptions.add(new UnparsedOption(optionEnum.longName));
    }

    public void addOption(OptionEnum optionEnum, String s1) {
        this.addOption(optionEnum);
        this.unparsedOptions.addArgToLast(s1);
    }

    public void addOption(OptionEnum optionEnum, String s1, String s2) {
        this.addOption(optionEnum);
        this.unparsedOptions.addArgToLast(s1);
        this.unparsedOptions.addArgToLast(s2);
    }

    public void addOption(OptionEnum optionEnum, String s1, String s2, String s3) {
        this.addOption(optionEnum);
        this.unparsedOptions.addArgToLast(s1);
        this.unparsedOptions.addArgToLast(s2);
        this.unparsedOptions.addArgToLast(s3);
    }

    public void addOption(OptionEnum optionEnum, String s1, String s2, String s3, String s4) {
        this.addOption(optionEnum);
        this.unparsedOptions.addArgToLast(s1);
        this.unparsedOptions.addArgToLast(s2);
        this.unparsedOptions.addArgToLast(s3);
        this.unparsedOptions.addArgToLast(s4);
    }

    public void addOption(OptionEnum optionEnum, String s1, Strings srest) {
        this.addOption(optionEnum);
        this.unparsedOptions.addArgToLast(s1);
        for (String s : srest) {
            this.unparsedOptions.addArgToLast(s);
        }
    }

    public void addOption(OptionEnum optionEnum, String s1, String s2, Strings srest) {
        this.addOption(optionEnum);
        this.unparsedOptions.addArgToLast(s1);
        this.unparsedOptions.addArgToLast(s2);
        for (String s : srest) {
            this.unparsedOptions.addArgToLast(s);
        }
    }

    public void startInstance() {
        new Thread(new SimTreeThread()).start();
    }

    public SimTreeContext getSimTreeContext() {
        return this.sc;
    }

    private class SimTreeThread
    implements Runnable {
        private SimTreeThread() {
        }

        @Override
        public void run() {
            try {
                new SimTree(SimTreeLauncher.this.commandDesc, Options.fromUnparsedOptions(SimTreeLauncher.this.unparsedOptions, OptionSourceEnum.COMMAND_LINE, SimTreeLauncher.this.sc), SimTreeLauncher.this.sc);
            }
            catch (SimTreeException e) {
                Message.fatal(e.getMessage(), SimTreeLauncher.this.sc);
            }
        }
    }
}

