/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.hooks;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.StringPairs;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.cmdrun.CommandReturn;
import ikr.simtree.cmdrun.CommandRunner;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;

public class HookFileCreator {
    public static final String HOOKNAME_SIMTREE_CALLSIM = "simtree-callsim";
    public static final String HOOKNAME_EXECUTE_SIMPROG_LOCAL = "execute-simprog-local";
    public static final String HOOKNAME_EXECUTE_SIMPROG_REMOTE = "execute-simprog-remote";
    public static final String HOOKNAME_CONDITION_NOTIFIER = "condition-notifier";
    public static final String HOOKNAME_PROCESS_CONTROLLER = "process-controller";
    private final String absFileName;
    private final String hookName;
    private final boolean deleteOnExit;
    private final LinkedHashMap<String, String> replacementPairs = new LinkedHashMap();

    public HookFileCreator(String hookName, String absFileName) {
        this.absFileName = absFileName;
        this.hookName = hookName;
        this.deleteOnExit = false;
    }

    public HookFileCreator(String hookName) {
        this.absFileName = String.valueOf(StudyRootVFS.getTempDirName()) + File.separator + hookName + "-" + Helpers.randomString(6) + ".sh";
        this.hookName = hookName;
        this.deleteOnExit = true;
    }

    public void addStringReplacement(String value, String replacement) {
        assert (value != null && value.length() != 0);
        this.replacementPairs.put(value, replacement != null ? replacement : "");
    }

    public void addBooleanReplacement(String value, boolean replacement) {
        assert (value != null && value.length() != 0);
        this.replacementPairs.put(value, replacement ? "Y" : "N");
    }

    public void addIntegerReplacement(String value, int replacement) {
        assert (value != null && value.length() != 0);
        this.replacementPairs.put(value, "" + replacement);
    }

    public void addBooleanPropsReplacements(String[] boolPropNames) throws SimTreeException {
        String[] stringArray = boolPropNames;
        int n = boolPropNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            this.addBooleanReplacement(Props.getCanonKeyName(propName), Props.getBool(propName));
            ++n2;
        }
    }

    public void addStringPropsReplacements(String[] stringPropNames) {
        String[] stringArray = stringPropNames;
        int n = stringPropNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            this.addStringReplacement(Props.getCanonKeyName(propName), Props.getStr(propName));
            ++n2;
        }
    }

    public void addIntegerPropsReplacements(String[] stringPropNames) throws SimTreeException {
        String[] stringArray = stringPropNames;
        int n = stringPropNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            this.addIntegerReplacement(Props.getCanonKeyName(propName), Props.getInt(propName));
            ++n2;
        }
    }

    public void createFile() throws SimTreeException {
        BufferedReader breader;
        File file = new File(this.absFileName);
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            throw new SimTreeException("Cannot overwrite existing file " + this.absFileName);
        }
        File srcHookFile = new File(String.valueOf(StudyRootVFS.getHooksDirName()) + File.separator + this.hookName);
        if (srcHookFile.canRead()) {
            try {
                breader = new BufferedReader(new FileReader(srcHookFile));
            }
            catch (FileNotFoundException e) {
                throw new SimTreeException("Cannot read hook file template " + srcHookFile.getAbsolutePath());
            }
            this.addStringReplacement("HOOK_FILE_SOURCE_COMMENT", "generated from user supplied hook file template " + srcHookFile.getAbsolutePath());
        } else {
            InputStream stream = this.getClass().getResourceAsStream("/res/hooks/" + this.hookName);
            if (stream == null) {
                throw new SimTreeException("Cannot open resource for builtin hook file template " + this.hookName);
            }
            breader = new BufferedReader(new InputStreamReader(stream));
            this.addStringReplacement("HOOK_FILE_SOURCE_COMMENT", "Generated from builtin hook file template " + this.hookName);
        }
        StringPairs values = new StringPairs();
        for (String key : this.replacementPairs.keySet()) {
            values.add(new StringPair(key, this.replacementPairs.get(key)));
        }
        Helpers.createFileFromTemplate(breader, this.absFileName, values);
        if (!new File(this.absFileName).setExecutable(true)) {
            throw new SimTreeException("Cannot set execute protection for file " + this.absFileName);
        }
    }

    public CommandReturn createAndExecute(CommandRunner commandRunner, CommandOutputHandler stdoutHandler, CommandOutputHandler stderrHandler) throws SimTreeException {
        this.createFile();
        if (this.deleteOnExit) {
            commandRunner.setNameOfFileToDelete(this.absFileName);
        }
        return commandRunner.run(this.absFileName, stdoutHandler, stderrHandler);
    }
}

