/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.Strings;
import ikr.simtree.help.Formatter;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParas;

public class TextFormatter
extends Formatter {
    public TextFormatter(HelpParas helpParas) {
        super(helpParas);
    }

    @Override
    public Strings getStrings() {
        Strings fullRet = new Strings();
        assert (this.helpParas.size() != 0);
        for (HelpPara helpPara : this.helpParas) {
            String firstLineSuffix = "";
            String restLineSuffix = "";
            String underlineStr = null;
            Strings content = helpPara.getPlainContent();
            switch (helpPara.helpParaTypeEnum) {
                case E0: {
                    break;
                }
                case E1: {
                    firstLineSuffix = "  ";
                    restLineSuffix = "  ";
                    break;
                }
                case E2: {
                    firstLineSuffix = "    ";
                    restLineSuffix = "    ";
                    break;
                }
                case EP1: {
                    firstLineSuffix = "* ";
                    restLineSuffix = "  ";
                    break;
                }
                case EP2: {
                    firstLineSuffix = "  * ";
                    restLineSuffix = "    ";
                    break;
                }
                case H1: {
                    underlineStr = "=";
                    break;
                }
                case H2: {
                    underlineStr = "-";
                    break;
                }
                case H3: {
                    underlineStr = "-";
                    break;
                }
                case H4: {
                    break;
                }
                case CMD: {
                    firstLineSuffix = "# ";
                    restLineSuffix = "  ";
                    break;
                }
                case CMD_HELP: {
                    firstLineSuffix = "     ";
                    restLineSuffix = "     ";
                    content.set(0, "(" + ((String)content.get(0)).trim());
                    content.set(content.size() - 1, String.valueOf(((String)content.get(content.size() - 1)).trim()) + ")");
                }
            }
            Strings ret = new Strings();
            if (helpPara.doReformat()) {
                content = TextFormatter.getBrokenString(content, 90 - firstLineSuffix.length());
            }
            int i = 0;
            while (i < content.size()) {
                String l = i == 0 ? String.valueOf(firstLineSuffix) + (String)content.get(i) : String.valueOf(restLineSuffix) + (String)content.get(i);
                ret.add(l);
                if (underlineStr != null) {
                    String ul = "";
                    int j = 0;
                    while (j < l.length()) {
                        ul = String.valueOf(ul) + underlineStr;
                        ++j;
                    }
                    ret.add(ul);
                }
                ++i;
            }
            if (underlineStr != null) {
                ret.add("");
            }
            i = 0;
            while (i < helpPara.getGapsAfter()) {
                ret.add("");
                ++i;
            }
            i = 0;
            while (i < helpPara.getGapsBefore()) {
                ret.add(0, "");
                ++i;
            }
            for (String s : ret) {
                fullRet.add(String.valueOf(SHelpers.indent(helpPara.indent)) + s);
            }
        }
        return fullRet;
    }

    private static Strings getBrokenString(Strings content, int cols) {
        Strings list = new Strings();
        if (cols < 2) {
            return list;
        }
        int currentCol = 0;
        String text = content.toSingleString().replaceAll("[\\s]+", " ");
        StringBuffer buf = new StringBuffer(text);
        while (currentCol < text.length()) {
            int copyCol;
            if (currentCol + cols >= text.length()) {
                assert (currentCol <= text.length());
                list.add(buf.substring(currentCol, text.length()).trim());
                break;
            }
            int i = copyCol = currentCol + cols;
            while (i > currentCol) {
                if (buf.charAt(i) == ' ') {
                    copyCol = i;
                    break;
                }
                --i;
            }
            list.add(buf.substring(currentCol, copyCol).trim());
            currentCol = copyCol;
            if (buf.charAt(currentCol) != ' ') continue;
            ++currentCol;
        }
        return list;
    }
}

