/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.help.CrossRef;
import ikr.simtree.help.CrossRefEnum;
import ikr.simtree.help.HTMLHelper;
import ikr.simtree.help.HeadLine;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.options.OptionEnum;

public abstract class HelpPara {
    protected final HelpParaTypeEnum helpParaTypeEnum;
    protected final int indent;
    protected final CrossRef crossRef;
    private int gapsAfter = 0;
    private int gapsBefore = 0;

    protected HelpPara(HelpParaTypeEnum helpParaTypeEnum, CrossRef crossRef, int indent) {
        this.helpParaTypeEnum = helpParaTypeEnum;
        this.indent = indent;
        this.crossRef = crossRef;
    }

    public void addGapAfter() {
        ++this.gapsAfter;
    }

    public int getGapsAfter() {
        return this.gapsAfter;
    }

    public void addGapBefore() {
        ++this.gapsBefore;
    }

    public int getGapsBefore() {
        return this.gapsBefore;
    }

    public abstract Strings getPlainContent();

    public abstract Strings getContent();

    public abstract Strings getHTMLContent() throws SimTreeException;

    protected abstract boolean doReformat();

    protected static String getPlainContentLine(String contentLine) {
        String ret = contentLine;
        CrossRefEnum[] crossRefEnumArray = CrossRefEnum.values();
        int n = crossRefEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CrossRefEnum crossRef = crossRefEnumArray[n2];
            ret = ret.replaceAll("\\Q" + crossRef.tag + "\\E", "");
            ++n2;
        }
        return ret;
    }

    protected static Strings getPlainContentLines(Strings contentLines) {
        Strings ret = new Strings();
        for (String s : contentLines) {
            ret.add(HelpPara.getPlainContentLine(s));
        }
        return ret;
    }

    protected static String getHTMLContentLine(String contentLine) throws SimTreeException {
        String ret = HTMLHelper.str2html(contentLine);
        ret = CommandEnum.replaceXrefMarks(ret);
        ret = OptionEnum.replaceXrefMarks(ret);
        ret = HeadLine.replaceXrefMarks(ret);
        return ret;
    }

    protected static Strings getHTMLContentLines(Strings contentLines, boolean doReformat) throws SimTreeException {
        Strings ret = new Strings();
        for (String s : contentLines) {
            ret.add(HelpPara.getHTMLContentLine(s));
            if (doReformat) continue;
            ret.add("<br>");
        }
        return ret;
    }
}

