/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.help.FixedHelpPara;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.SimpleHelpPara;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HelpFileReader {
    private final String helpTopic;
    private final String helpClass;

    protected HelpFileReader(String helpClass, String helpTopic) {
        this.helpTopic = helpTopic;
        this.helpClass = helpClass;
    }

    protected HelpParas getHelpFileParas(int indent) throws SimTreeException {
        return this.getHelpFileParas(null, indent);
    }

    protected HelpParas getHelpFileParas(String helpSubTopic, int indent) throws SimTreeException {
        HelpParas ret = new HelpParas();
        String rName = "/res/help/" + this.helpClass + "/" + this.helpTopic + (helpSubTopic == null ? "" : "." + helpSubTopic) + ".txt";
        InputStream stream = this.getClass().getResourceAsStream(rName);
        if (stream == null) {
            return null;
        }
        BufferedReader breader = new BufferedReader(new InputStreamReader(stream));
        Strings para = new Strings();
        try {
            String line;
            while ((line = breader.readLine()) != null) {
                if (line.trim().length() == 0) {
                    if (para.size() == 0) continue;
                    ret.addAll(this.paraToHelpParas(para, indent));
                    para = new Strings();
                    continue;
                }
                para.add(line);
            }
            if (para.size() != 0) {
                ret.addAll(this.paraToHelpParas(para, indent));
            }
        }
        catch (IOException e) {
            throw new SimTreeException("Cannot read help text from jar file (internal error)");
        }
        return ret;
    }

    private void err(String msg) throws SimTreeException {
        throw new SimTreeException("Error in Help text " + this.helpClass + "/" + this.helpTopic + ": " + msg);
    }

    private static String removeCharsFromString(String str, int num) {
        return str.substring(num);
    }

    private HelpParas paraToHelpParas(Strings para, int indent) throws SimTreeException {
        HelpParas helpParas = new HelpParas();
        assert (para.size() != 0);
        assert (((String)para.get(0)).length() != 0);
        Strings modifiedPara = para;
        String firstLine = (String)modifiedPara.get(0);
        boolean addGapAfter = true;
        if (firstLine.startsWith("**")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 2));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.EP2, indent, modifiedPara));
        } else if (firstLine.startsWith("*")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 1));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.EP1, indent, modifiedPara));
        } else if (firstLine.startsWith("..")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 1));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.E2, indent, modifiedPara));
        } else if (firstLine.startsWith(".")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 1));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.E1, indent, modifiedPara));
        } else if (firstLine.startsWith("#")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 1).trim());
            helpParas.add(new FixedHelpPara(HelpParaTypeEnum.CMD, indent, modifiedPara));
            addGapAfter = false;
        } else if (firstLine.startsWith("%%")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 2));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.CMD_HELP, indent, modifiedPara));
        } else if (firstLine.startsWith("!!")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 2));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.H3, indent, modifiedPara));
            addGapAfter = false;
        } else if (firstLine.startsWith("!")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 1));
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, modifiedPara));
        } else if (firstLine.startsWith("%pre")) {
            modifiedPara.set(0, HelpFileReader.removeCharsFromString(firstLine, 4));
            helpParas.add(new FixedHelpPara(HelpParaTypeEnum.E0, indent, modifiedPara));
        } else if (firstLine.startsWith("%inc")) {
            HelpParas incParas;
            String[] arg;
            if (modifiedPara.size() != 1) {
                this.err("%inc tag must appear in a one-line paragraph");
            }
            if ((arg = firstLine.split(" ")).length != 3) {
                this.err("Invalid %inc tag, usage is %inc <Class> <Topic>");
            }
            if ((incParas = new HelpFileReader(arg[1], arg[2]).getHelpFileParas(indent)) == null) {
                this.err("%inc content " + arg[1] + " " + arg[2] + " not found");
            }
            helpParas.addAll(incParas);
            addGapAfter = false;
        } else {
            helpParas.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, modifiedPara));
        }
        if (addGapAfter) {
            helpParas.addGapAfter();
        }
        return helpParas;
    }
}

