/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.help.CrossRef;
import ikr.simtree.help.CrossRefEnum;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.NumberGenerator;
import ikr.simtree.help.SimpleHelpPara;

public class HeadLine
extends SimpleHelpPara {
    private final String numStr;

    public HeadLine(HelpParaTypeEnum helpParaTypeEnum, NumberGenerator nums, CrossRef crossRef, String content) {
        super(helpParaTypeEnum, crossRef, 0, String.valueOf(nums.getStr()) + " " + content);
        this.numStr = nums.getStr();
    }

    public HeadLine(HelpParaTypeEnum helpParaTypeEnum, NumberGenerator nums, String text) {
        this(helpParaTypeEnum, nums, null, text);
    }

    @Override
    protected String getNumberString() {
        return this.numStr.trim();
    }

    public String toTOCText() {
        assert (this.getContent().size() == 1);
        return String.valueOf(CrossRefEnum.TOC.tag) + (String)this.getContent().get(0);
    }

    public static String replaceXrefMarks(String line) throws SimTreeException {
        String ret = line;
        if (ret.contains(CrossRefEnum.TOC.tag)) {
            int index = line.indexOf(" ");
            if (index < 3 || index == -1) {
                throw new SimTreeException("Invalid TOC tag in line [" + line + "]");
            }
            String tocString = line.substring(0, index);
            String rest = line.substring(index + 1);
            tocString = tocString.replaceAll("\\Q" + CrossRefEnum.TOC.tag + "\\E", "").trim();
            tocString = String.valueOf(new CrossRef(CrossRefEnum.TOC, tocString).toHTMLRefStart()) + tocString + CrossRef.toHTMLRefEnd();
            ret = String.valueOf(tocString) + rest;
        }
        return ret;
    }
}

