/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.tree;

import ikr.simtree.gui.AddToChartMenuGenerator;
import ikr.simtree.gui.chart.ChartDataCollectorFactory;
import ikr.simtree.gui.tree.TreeViewerPanel;
import ikr.simtree.gui.tree.ValueInTree;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ColumnDefinitionOption;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class ValueInTreeForDump
extends ValueInTree {
    public ValueInTreeForDump(String valueString, SimTreeContext sc) {
        super(valueString, sc);
    }

    @Override
    public void addNodeSpecificContextMenuItems(JPopupMenu popupMenu, Font font, TreePath treePath) {
        if (treePath.getPath().length > 1) {
            AddToChartMenuGenerator.addChartContextMenuItems(popupMenu, font, new PopupMouseAdapter(treePath), false);
        }
    }

    @Override
    public void onNodeSelected() {
    }

    private class PopupMouseAdapter
    extends MouseAdapter {
        private final String resultPathString;

        public PopupMouseAdapter(TreePath treePath) {
            this.resultPathString = TreeViewerPanel.resultPathStringFromTreePath(treePath);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            String menuText = ((JMenuItem)e.getSource()).getText();
            if (menuText.equals("as X Axis value")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().setxAxisString(ColumnDefinitionOption.ColKindEnum.RESULT_PATH, this.resultPathString);
            } else if (menuText.equals("as Y Axis value")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().setyAxisString(ColumnDefinitionOption.ColKindEnum.RESULT_PATH, this.resultPathString);
            } else if (menuText.equals("as family value")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().setFamilyString(ColumnDefinitionOption.ColKindEnum.RESULT_PATH, this.resultPathString);
            } else assert (false);
        }
    }
}

