/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.tree;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.gui.TabPanel;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.gui.tree.ValueInTree;
import ikr.simtree.launch.SimTreeContext;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeViewerPanel
extends TabPanel {
    private final JTree tree;
    private static final Font font = new Font("Dialog", 0, 12);
    private static final int MAX_EXPAND_ROWS = 20000;

    protected TreeViewerPanel(TabTypeEnum tabTypeEnum, String longTitle, DefaultMutableTreeNode top, boolean expandAll, SimTreeContext sc) {
        super(longTitle, sc, tabTypeEnum);
        this.setLayout(new GridLayout(1, 0));
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        if (expandAll) {
            this.expandAll();
        }
        this.tree.addMouseListener(new TreeMouseAdapter());
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tree);
        this.add(scrollPane);
    }

    protected static String resultPathStringFromTreePath(TreePath treePath) {
        Object[] os = treePath.getPath();
        String rp = "";
        int i = 1;
        while (i < os.length) {
            String pe = os[i].toString();
            int spaceIndex = pe.indexOf(32);
            rp = spaceIndex != -1 ? String.valueOf(rp) + pe.substring(0, spaceIndex) : String.valueOf(rp) + pe;
            rp = String.valueOf(rp) + (i < os.length - 1 ? ":" : "");
            ++i;
        }
        return rp;
    }

    private void expandAll() {
        int i = 0;
        while (i < this.tree.getRowCount()) {
            if (i == 20000) {
                Message.notice("Too many rows to expand, will limit", this.sc);
                break;
            }
            this.tree.expandRow(i);
            ++i;
        }
    }

    private static enum DefaultPopupMenuActions {
        EXPAND_ALL("Expand all"),
        COLLAPSE_ALL("Collapse all"),
        EXPAND_NODE("Expand node"),
        COLLAPSE_NODE("Collapse node");

        public final String menuLabel;

        private DefaultPopupMenuActions(String menuLabel) {
            this.menuLabel = menuLabel;
        }

        public static DefaultPopupMenuActions fromString(String menuLabel) {
            DefaultPopupMenuActions[] defaultPopupMenuActionsArray = DefaultPopupMenuActions.values();
            int n = defaultPopupMenuActionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultPopupMenuActions a = defaultPopupMenuActionsArray[n2];
                if (menuLabel.equals(a.menuLabel)) {
                    return a;
                }
                ++n2;
            }
            return null;
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            String resultPathString;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreeViewerPanel.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            ((ValueInTree)node.getUserObject()).onNodeSelected();
            TreePath selectedTreePath = TreeViewerPanel.this.tree.getSelectionPath();
            if (selectedTreePath != null && (resultPathString = TreeViewerPanel.resultPathStringFromTreePath(selectedTreePath)).length() != 0) {
                Message.notice("ResultPath is " + TreeViewerPanel.resultPathStringFromTreePath(selectedTreePath), TreeViewerPanel.this.sc);
            }
        }
    }

    private class PopupMouseAdapter
    extends MouseAdapter {
        private final TreePath treePath;
        private final int selRow;

        public PopupMouseAdapter(TreePath treePath, int selRow) {
            this.treePath = treePath;
            this.selRow = selRow;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            DefaultPopupMenuActions action = DefaultPopupMenuActions.fromString(source.getText());
            block0 : switch (action) {
                case EXPAND_ALL: {
                    TreeViewerPanel.this.expandAll();
                    break;
                }
                case COLLAPSE_ALL: {
                    int i = 0;
                    while (i < TreeViewerPanel.this.tree.getRowCount()) {
                        if (i == 20000) {
                            Message.notice("Too many rows to collapse, will limit", TreeViewerPanel.this.sc);
                            break block0;
                        }
                        TreeViewerPanel.this.tree.collapseRow(i);
                        ++i;
                    }
                    break;
                }
                case EXPAND_NODE: {
                    TreeViewerPanel.this.tree.expandRow(this.selRow);
                    break;
                }
                case COLLAPSE_NODE: {
                    TreeViewerPanel.this.tree.collapseRow(this.selRow);
                }
            }
        }
    }

    private class TreeMouseAdapter
    extends MouseAdapter {
        private TreeMouseAdapter() {
        }

        private JMenuItem createMenuItem(String label, TreePath treePath, int selectedRow) {
            JMenuItem menuItem = new JMenuItem(label);
            menuItem.addMouseListener(new PopupMouseAdapter(treePath, selectedRow));
            menuItem.setFont(font);
            return menuItem;
        }

        private void maybeShowPopup(MouseEvent e) {
            int selectedRow = TreeViewerPanel.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selectedRow == -1) {
                return;
            }
            if (e.isPopupTrigger()) {
                TreePath selectedTreePath = TreeViewerPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                JPopupMenu popup = new JPopupMenu();
                DefaultPopupMenuActions[] defaultPopupMenuActionsArray = DefaultPopupMenuActions.values();
                int n = defaultPopupMenuActionsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DefaultPopupMenuActions a = defaultPopupMenuActionsArray[n2];
                    popup.add(this.createMenuItem(a.menuLabel, selectedTreePath, selectedRow));
                    ++n2;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedTreePath.getLastPathComponent();
                if (node != null) {
                    try {
                        ((ValueInTree)node.getUserObject()).addNodeSpecificContextMenuItems(popup, font, selectedTreePath);
                    }
                    catch (SimTreeException e1) {
                        Message.fatal(e1.getMessage(), TreeViewerPanel.this.sc);
                    }
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }
    }
}

