/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.dialogs;

import ikr.simtree.base.Strings;
import ikr.simtree.simpara.SimParaFragments;
import ikr.simtree.simpara.SimParaTypeEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SimParaDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final int width = 560;
    private static final int height = 240;
    private SimParaFragments simParaFragments;
    private JTextField textFieldName;
    private JTextField textFieldValues;
    private JComboBox comboType;
    private JButton buttonOk;
    private static final String[] typeComboValues = new String[SimParaTypeEnum.values().length + 1];

    static {
        SimParaDialog.typeComboValues[0] = "-";
        ArrayList<String> names = new ArrayList<String>();
        SimParaTypeEnum[] simParaTypeEnumArray = SimParaTypeEnum.values();
        int n = simParaTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimParaTypeEnum e = simParaTypeEnumArray[n2];
            names.add(e.typeName);
            ++n2;
        }
        assert (names.size() == typeComboValues.length - 1);
        int i = 0;
        while (i < names.size()) {
            SimParaDialog.typeComboValues[i + 1] = (String)names.get(i);
            ++i;
        }
    }

    public SimParaDialog(SimParaFragments simParaValues) {
        this.simParaFragments = simParaValues;
        assert (simParaValues != null);
        this.initComponents();
        this.setModal(true);
        this.buttonOk.setEnabled(false);
        this.setTitle("SimTree Simulation Parameter Entry");
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel panelMain = new JPanel(new BorderLayout());
        this.buttonOk = new JButton("Ok");
        JButton buttonCancel = new JButton("Cancel");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimParaDialog.this.actionOk();
            }
        });
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimParaDialog.this.actionCancel();
            }
        });
        JPanel panelBottom = new JPanel();
        panelBottom.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        panelBottom.add(this.buttonOk);
        panelBottom.add(buttonCancel);
        panelMain.add((Component)panelBottom, "South");
        JPanel panelTop = new JPanel(new BorderLayout());
        JPanel panelEntry = new JPanel(new GridLayout(3, 2, 10, 10));
        panelEntry.setBorder(new EmptyBorder(new Insets(20, 10, 50, 10)));
        JLabel labelSimParaName = new JLabel("Simulation Parameter Name");
        labelSimParaName.setFont(new Font("Dialog", 1, 14));
        labelSimParaName.setHorizontalAlignment(4);
        String initName = this.simParaFragments.getSimParaName();
        this.textFieldName = new JTextField();
        if (initName == null) {
            initName = "";
        } else {
            this.textFieldName.setEditable(false);
        }
        this.textFieldName.setText(initName);
        panelEntry.add(labelSimParaName);
        panelEntry.add(this.textFieldName);
        JLabel labelType = new JLabel("Type of simulation parameter");
        labelType.setFont(new Font("Dialog", 1, 14));
        labelType.setHorizontalAlignment(4);
        this.comboType = new JComboBox<String>(typeComboValues);
        if (this.simParaFragments.getSimParaType() != null) {
            int preset = -1;
            int i = 0;
            while (i < typeComboValues.length) {
                if (typeComboValues[i].equals(this.simParaFragments.getSimParaType().typeName)) {
                    preset = i;
                }
                ++i;
            }
            assert (preset != -1);
            this.comboType.setSelectedIndex(preset);
            this.comboType.setEnabled(false);
        }
        panelEntry.add(labelType);
        panelEntry.add(this.comboType);
        JLabel labelSimParaValues = new JLabel("Values (blank separated)");
        labelSimParaValues.setFont(new Font("Dialog", 1, 14));
        labelSimParaValues.setHorizontalAlignment(4);
        assert (this.simParaFragments.getValueStrings() == null);
        this.textFieldValues = new JTextField();
        panelEntry.add(labelSimParaValues);
        panelEntry.add(this.textFieldValues);
        JPanel panelOuter = new JPanel(new BorderLayout());
        JPanel panelInnerButton = new JPanel();
        JPanel panelSub = new JPanel(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SimParaDialog.this.closeDialog();
            }
        });
        panelTop.setBorder(new EmptyBorder(new Insets(20, 10, 50, 10)));
        JPanel panelTopLabel = new JPanel(new BorderLayout());
        panelTopLabel.setBorder(new EmptyBorder(new Insets(20, 10, 50, 10)));
        JLabel topLabel = new JLabel("Simulation Parameter entry dialog");
        panelTopLabel.add((Component)topLabel, "Center");
        topLabel.setHorizontalAlignment(0);
        topLabel.setVerticalAlignment(0);
        topLabel.setFont(new Font("Dialog", 1, 16));
        panelTop.add((Component)topLabel, "North");
        panelTop.add((Component)panelEntry, "South");
        panelMain.add((Component)panelTop, "North");
        panelInnerButton.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        panelSub.setBorder(new EmptyBorder(new Insets(5, 35, 10, 35)));
        panelOuter.add((Component)panelSub, "South");
        panelMain.add((Component)panelOuter, "Center");
        this.getContentPane().add((Component)panelMain, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 560) / 2, (screenSize.height - 240) / 2, 560, 240);
        this.textFieldName.getDocument().addDocumentListener(this);
        this.textFieldValues.getDocument().addDocumentListener(this);
        this.comboType.addActionListener(this);
    }

    private void actionOk() {
        this.setSimParaValue();
        assert (this.simParaFragments.isValid());
        this.closeDialog();
    }

    private void actionCancel() {
        this.simParaFragments = null;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public SimParaFragments getEnteredValue() {
        return this.simParaFragments;
    }

    private void setSimParaValue() {
        this.simParaFragments.setSimParaName(this.textFieldName.getText());
        int selected = this.comboType.getSelectedIndex();
        if (selected != -1 && selected != 0) {
            String selStr = typeComboValues[selected];
            this.simParaFragments.setSimParaType(SimParaTypeEnum.fromString(selStr));
        } else {
            this.simParaFragments.setSimParaType(null);
        }
        String val = this.textFieldValues.getText();
        String[] vals = val.split(" ");
        Strings valss = new Strings();
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            valss.add(s);
            ++n2;
        }
        this.simParaFragments.setValueStrings(valss);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSimParaValue();
        this.buttonOk.setEnabled(this.simParaFragments.isValid());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }
}

