/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.chart;

import ikr.simtree.gui.chart.TracePoint2DWithErrVal;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyRelative;
import java.util.ArrayList;

public class SimTreeErrorBarPolicy
extends ErrorBarPolicyRelative {
    private ArrayList<TracePoint2DWithErrVal> tracePointsWithErrVal;

    protected SimTreeErrorBarPolicy(ArrayList<TracePoint2DWithErrVal> tracePointsWithErrVal) {
        super(1.0E-17);
        this.tracePointsWithErrVal = tracePointsWithErrVal;
        this.setRelativeYError(0.1);
    }

    private TracePoint2DWithErrVal getTracePointWithErrVal(ITracePoint2D tracePoint) {
        for (TracePoint2DWithErrVal tp : this.tracePointsWithErrVal) {
            if (tp.tracePoint2D != tracePoint) continue;
            return tp;
        }
        assert (false);
        return null;
    }

    protected int internalGetNegativeYError(int xPixel, int yPixel, ITracePoint2D original) {
        Double barLen = this.getTracePointWithErrVal((ITracePoint2D)original).errorYdown;
        int error = (int)Math.round((double)(this.getTrace().getRenderer().getYChartStart() - yPixel) * (barLen / original.getY()));
        return yPixel + error;
    }

    protected int internalGetPositiveYError(int xPixel, int yPixel, ITracePoint2D original) {
        Double barLen = this.getTracePointWithErrVal((ITracePoint2D)original).errorYup;
        int error = (int)Math.round((double)(this.getTrace().getRenderer().getYChartStart() - yPixel) * (barLen / original.getY()));
        return yPixel - error;
    }

    protected int internalGetNegativeXError(int xPixel, int yPixel, ITracePoint2D original) {
        Double barLen = this.getTracePointWithErrVal((ITracePoint2D)original).errorXleft;
        int error = (int)Math.round((double)(this.getTrace().getRenderer().getXChartStart() - xPixel) * (barLen / original.getX()));
        return xPixel - error;
    }

    protected int internalGetPositiveXError(int xPixel, int yPixel, ITracePoint2D original) {
        Double barLen = this.getTracePointWithErrVal((ITracePoint2D)original).errorXright;
        int error = (int)Math.round((double)(this.getTrace().getRenderer().getXChartStart() - xPixel) * (barLen / original.getX()));
        return xPixel + error;
    }
}

