/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.chart;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.gui.TabPanel;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.gui.chart.ChartLayout;
import ikr.simtree.launch.SimTreeContext;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.UIManager;

public class ChartViewerPanel
extends TabPanel {
    private static final Color[] colorArr = new Color[]{Color.BLACK, Color.BLUE, Color.GREEN, Color.RED, Color.CYAN};
    private final String[] headLineElements;

    public ChartViewerPanel(String longTitle, String[] headlineElements, SimTreeContext sc) {
        super(longTitle, sc, TabTypeEnum.CHART);
        this.headLineElements = headlineElements;
    }

    protected void createChart(List<String> tableHeaders, List<List<String>[]> graphDataLists, ChartLayout chartLayout) throws SimTreeException {
        Chart2D chart = new Chart2D();
        Font titleFont = UIManager.getDefaults().getFont("Label.font").deriveFont(14.0f).deriveFont(1);
        IAxis.AxisTitle axisTitle = chart.getAxisY().getAxisTitle();
        axisTitle.setTitleFont(titleFont);
        axisTitle.setTitle(this.headLineElements[1]);
        axisTitle = chart.getAxisX().getAxisTitle();
        axisTitle.setTitleFont(titleFont);
        axisTitle.setTitle(this.headLineElements[0]);
        chart.getAxisX().setPaintGrid(true);
        chart.getAxisY().setPaintGrid(true);
        int table = 0;
        while (table < tableHeaders.size()) {
            Trace2DSimple trace = new Trace2DSimple();
            chart.addTrace((ITrace2D)trace);
            int point = 0;
            while (point < graphDataLists.get(table)[0].size()) {
                List<String>[] lineData = graphDataLists.get(table);
                if (lineData.length < chartLayout.colX || lineData.length < chartLayout.colY) {
                    throw new SimTreeException("Required column not in results");
                }
                try {
                    if (chartLayout.hasSymmetricErrorBars) {
                        if (lineData.length < chartLayout.colErrorBar) {
                            throw new SimTreeException("Required column for error bars not in results");
                        }
                    } else {
                        trace.addPoint((ITracePoint2D)new TracePoint2D(new Double(lineData[chartLayout.colX].get(point)).doubleValue(), new Double(lineData[chartLayout.colY].get(point)).doubleValue()));
                    }
                }
                catch (NumberFormatException e) {
                    throw new SimTreeException("Invalid value for Graph (not numeric)");
                }
                ++point;
            }
            trace.setName(tableHeaders.get(table));
            trace.addTracePainter((ITracePainter)new TracePainterDisc());
            trace.setColor(colorArr[table % colorArr.length]);
            ++table;
        }
        this.setLayout(new BorderLayout());
        ChartPanel chartpanel = new ChartPanel(chart);
        this.add((Component)chartpanel, "Center");
    }
}

