/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabLabelWithCloseButton
extends JPanel {
    private final JTabbedPane tabbedPane;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).setBorderPainted(false);
            }
        }
    };

    public TabLabelWithCloseButton(JTabbedPane tabbedPane, String title) {
        super(new FlowLayout(0, 0, 0));
        assert (tabbedPane != null);
        this.tabbedPane = tabbedPane;
        this.setOpaque(false);
        JLabel label = new JLabel(title);
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.add(new TabButton());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Close");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = TabLabelWithCloseButton.this.tabbedPane.indexOfTabComponent(TabLabelWithCloseButton.this);
            if (i != -1) {
                TabLabelWithCloseButton.this.tabbedPane.remove(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

