/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.graphwriter;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphdata.GraphData;
import ikr.simtree.graphwriter.FamilyGraphWriter;
import ikr.simtree.graphwriter.FlatGraphWriter;
import ikr.simtree.graphwriter.GraphWriterEnum;
import ikr.simtree.graphwriter.GraphWriterI;
import ikr.simtree.launch.SimTreeContext;

public abstract class GraphWriterFactory {
    public static GraphWriterI factory(GraphWriterEnum graphWriterEnum, GraphData graphData, String[] additionalArguments, boolean visual, SimTreeContext sc) throws SimTreeException {
        GraphWriterI graphWriter = null;
        switch (graphWriterEnum) {
            case EXTERNAL: {
                if (additionalArguments == null || additionalArguments.length < 1) {
                    throw new SimTreeException("Need class name of external graph writer");
                }
                String graphWriterClassName = additionalArguments[0];
                try {
                    graphWriter = (GraphWriterI)Class.forName(graphWriterClassName).newInstance();
                    break;
                }
                catch (InstantiationException e) {
                    throw new SimTreeException("Cannot instantiate external graph writer " + graphWriterClassName);
                }
                catch (IllegalAccessException e) {
                    throw new SimTreeException("Cannot access external graph writer " + graphWriterClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new SimTreeException("External graph writer " + graphWriterClassName + " not found");
                }
            }
            case FLAT: {
                graphWriter = new FlatGraphWriter(visual, sc);
                break;
            }
            case FAMILY: {
                graphWriter = new FamilyGraphWriter(visual, sc);
            }
        }
        assert (graphWriter != null);
        graphWriter.setGraphData(graphData);
        graphWriter.setAdditionalArguments(additionalArguments);
        return graphWriter;
    }
}

