/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.graphwriter;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphdata.GraphDataEval;
import ikr.simtree.graphwriter.GraphWriter;
import ikr.simtree.launch.SimTreeContext;
import java.util.List;

public class FamilyGraphWriter
extends GraphWriter {
    protected FamilyGraphWriter(boolean visual, SimTreeContext sc) {
        super(visual, sc);
    }

    @Override
    public void showGraph() throws SimTreeException {
        String s = "This writer requires one numeric parameter (column number), range from 0 to max column index - 1";
        if (this.additionalArguments == null || this.additionalArguments != null && this.additionalArguments.length != 1) {
            throw new SimTreeException(s);
        }
        int familyCol = -1;
        try {
            familyCol = new Integer(this.additionalArguments[0]);
        }
        catch (NumberFormatException e) {
            throw new SimTreeException(s);
        }
        if (familyCol < 0 || familyCol >= this.graphData.getNumOfCols()) {
            throw new SimTreeException(s);
        }
        for (List<String>[] curve : GraphDataEval.getFamilyDiagramData(this.graphData, familyCol)) {
            String tableHeader = "[" + this.graphData.getGraphHeadlineElements()[familyCol] + " " + curve[familyCol].get(0) + "]";
            this.printOneTable(tableHeader, curve, SHelpers.indent(1));
        }
        this.printGraph(true);
    }
}

