/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.eval;

import ikr.simtree.base.SHelpers;
import ikr.simtree.eval.BaseParseResultWithResultDef;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.resultdef.SingleRunResultDef;

public class FullParseResult
extends BaseParseResultWithResultDef {
    private final String name;
    private final String type;
    private final PrintServerPath psPath;
    private final int pLevel;

    public FullParseResult(int pLevel, String name, String value, String type, PrintServerPath psPath, SingleRunResultDef singleRunResultDef) {
        super(value, singleRunResultDef);
        assert (name != null);
        assert (type != null);
        this.pLevel = pLevel;
        this.name = name;
        this.type = type;
        this.psPath = psPath;
    }

    public FullParseResult(int pLevel, String name, String value, PrintServerPath psPath, SingleRunResultDef singleRunResultDef) {
        super(value, singleRunResultDef);
        assert (name != null);
        this.pLevel = pLevel;
        this.name = name;
        this.type = null;
        this.psPath = psPath;
    }

    @Override
    protected String toFormattedString(boolean verbose) {
        String v = this.type == null ? String.valueOf(SHelpers.indent(this.pLevel)) + this.value + " (" + this.name + ")" : String.valueOf(SHelpers.indent(this.pLevel)) + this.value + SHelpers.blanks(14 - this.value.length(), true) + "(" + this.type + " " + this.name + ")";
        if (verbose && this.psPath != null) {
            v = String.valueOf(v) + SHelpers.blanks(48 - v.length(), true) + "[" + this.psPath.toComposedString() + "]";
        }
        return v;
    }
}

