/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control.comm;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.control.comm.ControlServerRunner;
import ikr.simtree.control.comm.DBusControlRequestHandler;
import ikr.simtree.launch.SimTreeContext;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.exceptions.DBusException;

public class DBusServerRunner
extends ControlServerRunner {
    protected static final int DBUS_BUS_ID = 1;
    protected static final String DBUS_BUS_NAME = "ikr.simtree.server";
    protected static final String DBUS_OBJECT_NAME = "/SimTree/Control";
    private final SimTreeContext sc;
    private DBusConnection dBusConnection;

    protected DBusServerRunner(SimTreeContext sc) {
        this.sc = sc;
    }

    @Override
    public void stopControl() throws SimTreeException {
        if (this.dBusConnection != null) {
            this.dBusConnection.disconnect();
        }
        this.dBusConnection = null;
    }

    @Override
    public void startControl() throws SimTreeException {
        try {
            this.dBusConnection = DBusConnection.getConnection((int)1);
            this.dBusConnection.requestBusName(DBUS_BUS_NAME);
            this.dBusConnection.exportObject(DBUS_OBJECT_NAME, (DBusInterface)new DBusControlRequestHandler(this.sc));
        }
        catch (DBusException e) {
            if (this.dBusConnection != null) {
                this.dBusConnection.disconnect();
            }
            this.dBusConnection = null;
        }
    }
}

