/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.control.ControlAnswer;
import ikr.simtree.control.ControlMethodEnum;
import ikr.simtree.control.ControlMethodParameterEnum;
import ikr.simtree.control.ControlRequest;
import ikr.simtree.control.ObjectCommandHandler;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;
import ikr.simtree.workingset.WorkDesc;
import ikr.simtree.workingset.WorkDescs;
import ikr.simtree.workingset.WorkingSet;

public class WSObjectCommandHandler
extends ObjectCommandHandler {
    @Override
    protected ControlAnswer handle(ControlRequest controlRequest, Options options, SimTreeContext sc) throws SimTreeException {
        ControlAnswer answer = new ControlAnswer();
        WorkingSet currentWorkingSet = sc.getCurrentWorkingSet();
        if (currentWorkingSet == null) {
            throw new SimTreeException("No current working set");
        }
        switch (controlRequest.controlMethod) {
            case LIST: {
                answer.addAnswer("Work item list", 0);
                if (controlRequest.controlMethodParameters.size() == 0) {
                    answer.addAnswer(currentWorkingSet.toDisplayStringsWaiting(), 1);
                    answer.addAnswer(currentWorkingSet.toDisplayStringsRunning(), 1);
                    answer.addAnswer(currentWorkingSet.toDisplayStringsFinished(), 1);
                    break;
                }
                for (ControlMethodParameterEnum para : controlRequest.controlMethodParameters) {
                    switch (para) {
                        case FINISHED: {
                            answer.addAnswer(currentWorkingSet.toDisplayStringsFinished(), 1);
                            break;
                        }
                        case RUNNING: {
                            answer.addAnswer(currentWorkingSet.toDisplayStringsRunning(), 1);
                            break;
                        }
                        case WAITING: {
                            answer.addAnswer(currentWorkingSet.toDisplayStringsWaiting(), 1);
                        }
                    }
                }
                break;
            }
            case ADD: 
            case REMOVE: {
                String verb;
                WorkingSet workingSet = WSObjectCommandHandler.createWorkingSetFromOptions(options, controlRequest.controlMethod == ControlMethodEnum.ADD, sc);
                WorkDescs workDescsHandled = controlRequest.controlMethod == ControlMethodEnum.ADD ? currentWorkingSet.merge(workingSet) : currentWorkingSet.subtract(workingSet);
                String string = verb = controlRequest.controlMethod == ControlMethodEnum.ADD ? "added" : "removed";
                if (workDescsHandled.size() == 0) {
                    answer.addAnswer("No work items " + verb, 0);
                    break;
                }
                answer.addAnswer("The following work items were " + verb, 0);
                for (WorkDesc workDesc : workDescsHandled) {
                    answer.addAnswer(String.valueOf(SHelpers.indent(1)) + workDesc.toFormattedString(), 1);
                }
                break;
            }
            default: {
                answer.addAnswer("Internal error", 0);
            }
        }
        return answer;
    }
}

