/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.control.ControlAnswer;
import ikr.simtree.control.ControlMethodEnum;
import ikr.simtree.control.ControlRequest;
import ikr.simtree.control.ObjectCommandHandler;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.LocalProcessSlotsOption;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.RemoteProcessSlotsOption;
import ikr.simtree.runsim.ProcessScheduler;

public class SlotsObjectCommandHandler
extends ObjectCommandHandler {
    @Override
    protected ControlAnswer handle(ControlRequest controlRequest, Options options, SimTreeContext sc) throws SimTreeException {
        ControlAnswer answer = new ControlAnswer();
        ProcessScheduler processScheduler = sc.getCurrentProcessScheduler();
        if (processScheduler == null) {
            throw new SimTreeException("No current slot list");
        }
        switch (controlRequest.controlMethod) {
            case LIST: {
                answer.addAnswer("Slot list", 0);
                answer.addAnswer(processScheduler.getSlotStatusStrings(), 1);
                break;
            }
            case ADD: 
            case REMOVE: {
                int countSlot = 0;
                LocalProcessSlotsOption lps = (LocalProcessSlotsOption)options.getOption(OptionEnum.LOCAL_PROCESS_SLOTS);
                if (lps != null) {
                    int i = 0;
                    while (i < lps.getNumberOfSlots()) {
                        switch (controlRequest.controlMethod) {
                            case ADD: {
                                countSlot += processScheduler.addLocalSlot();
                                break;
                            }
                            case REMOVE: {
                                countSlot += processScheduler.removeLocalSlot();
                                break;
                            }
                            default: {
                                throw new SimTreeException("Internal error");
                            }
                        }
                        ++i;
                    }
                }
                for (Option o : options.getOptions(OptionEnum.REMOTE_PROCESS_SLOTS)) {
                    RemoteProcessSlotsOption ro = (RemoteProcessSlotsOption)o;
                    int i = 0;
                    while (i < ro.getNumberOfSlots()) {
                        switch (controlRequest.controlMethod) {
                            case ADD: {
                                countSlot += processScheduler.addRemoteSlot(ro.getHost());
                                break;
                            }
                            case REMOVE: {
                                countSlot += processScheduler.removeRemoteSlot(ro.getHost());
                                break;
                            }
                            default: {
                                throw new SimTreeException("Internal error");
                            }
                        }
                        ++i;
                    }
                }
                if (countSlot != 0) {
                    answer.addAnswer(countSlot + " Slots " + (controlRequest.controlMethod == ControlMethodEnum.ADD ? "added" : "removed"), 0);
                    break;
                }
                answer.addAnswer("No Slots found", 0);
                break;
            }
            default: {
                answer.addAnswer("Internal error", 0);
            }
        }
        return answer;
    }
}

