/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.control.ControlAnswer;
import ikr.simtree.control.ControlMethodEnum;
import ikr.simtree.control.ControlRequest;
import ikr.simtree.control.ObjectCommandHandler;
import ikr.simtree.control.ProcessList;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;
import ikr.simtree.workingset.WorkItem;
import ikr.simtree.workingset.WorkingSet;

public class ProcsObjectCommandHandler
extends ObjectCommandHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected ControlAnswer handle(ControlRequest controlRequest, Options options, SimTreeContext sc) throws SimTreeException {
        ControlAnswer answer = new ControlAnswer();
        ProcessList processList = sc.getCurrentProcessList();
        switch (controlRequest.controlMethod) {
            case LIST: {
                answer.addAnswer("Process list", 0);
                answer.addAnswer(processList.getProcessStatusList(), 1);
                return answer;
            }
            case KILL: {
                WorkingSet workingSet = ProcsObjectCommandHandler.createWorkingSetFromOptions(options, controlRequest.controlMethod == ControlMethodEnum.ADD, sc);
                boolean atLeastOne = false;
                assert (false);
                while (true) {
                    WorkItem workItem;
                    if ((workItem = workingSet.getNextWaitingAndMoveFromWaitingToRunning()) == null) {
                        if (atLeastOne) return answer;
                        answer.addAnswer("Nothing to do", 0);
                        return answer;
                    }
                    atLeastOne = true;
                    answer.addAnswer("Killing processes for " + workItem.workDesc.toFormattedString(), 0);
                    answer.addAnswer(processList.killProcess(workItem), 1);
                }
            }
        }
        answer.addAnswer("Internal error", 0);
        return answer;
    }
}

