/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.control.ProcessDescription;
import ikr.simtree.workingset.WorkItem;
import java.util.ArrayList;
import java.util.List;

public class ProcessList {
    private final List<ProcessDescription> processDescriptions = new ArrayList<ProcessDescription>();

    public synchronized void add(ProcessDescription processInfo) {
        this.processDescriptions.add(processInfo);
    }

    public synchronized void remove(ProcessDescription processInfo) {
        this.processDescriptions.remove(processInfo);
    }

    public synchronized Strings getProcessStatusList() throws SimTreeException {
        for (ProcessDescription desc : this.processDescriptions) {
            desc.requestStatusInfo();
        }
        Helpers.pauseThread(500L);
        Strings ret = new Strings();
        for (ProcessDescription desc : this.processDescriptions) {
            ret.addAll(desc.getProcessInfo());
        }
        return ret;
    }

    public synchronized Strings killProcess(WorkItem workItem) throws SimTreeException {
        Strings ret = new Strings();
        boolean found = false;
        for (ProcessDescription desc : this.processDescriptions) {
            if (!desc.workDesc.matches(workItem.workDesc, true)) continue;
            if (found) {
                throw new SimTreeException("More than one process found for this work item");
            }
            ret.addAll(desc.killProcessFamily());
            found = true;
        }
        if (!found) {
            ret.add("No process for this work item found");
        }
        return ret;
    }
}

