/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.control.channel.ChannelCommandEnum;
import ikr.simtree.control.channel.ChannelEnum;
import ikr.simtree.control.channel.ChannelMessage;
import ikr.simtree.workingset.WorkDesc;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class ProcessDescription {
    public final WorkDesc workDesc;
    private final Process process;
    private final CommandOutputHandler stdoutHandler;

    public ProcessDescription(Process process, CommandOutputHandler stdoutHandler, WorkDesc workDesc) {
        this.workDesc = workDesc;
        this.process = process;
        this.stdoutHandler = stdoutHandler;
    }

    private void writeToStdout(ChannelMessage message) throws SimTreeException {
        OutputStreamWriter stdinWriter = new OutputStreamWriter(this.process.getOutputStream());
        try {
            stdinWriter.write(String.valueOf(message.toChannelMessageString()) + "\n");
            stdinWriter.flush();
        }
        catch (IOException e) {
            throw new SimTreeException("Writing stdin to process failed");
        }
    }

    private ChannelMessage waitForAnswer(ChannelEnum channel, ChannelCommandEnum channelCommand, int timeoutMilliSeconds) {
        return this.stdoutHandler.getUpstreamMessageCollector().waitAndRetrieve(channel, channelCommand, timeoutMilliSeconds);
    }

    protected void requestStatusInfo() throws SimTreeException {
        this.writeToStdout(new ChannelMessage(ChannelEnum.PS, ChannelCommandEnum.STAT));
    }

    protected Strings killProcessFamily() throws SimTreeException {
        this.writeToStdout(new ChannelMessage(ChannelEnum.PS, ChannelCommandEnum.KILL));
        ChannelMessage mess = this.waitForAnswer(ChannelEnum.PS, ChannelCommandEnum.KILL, 3000);
        if (mess == null) {
            return new Strings("No answer from controller");
        }
        return new Strings(mess.toDisplayString());
    }

    protected boolean isProcessInfoAvailable() {
        return this.stdoutHandler.getUpstreamMessageCollector().isMessageAvail(ChannelEnum.PS, ChannelCommandEnum.STAT);
    }

    public Strings getProcessInfo() {
        Strings ret = new Strings();
        ret.add(this.workDesc.toFormattedString());
        ChannelMessage answer = null;
        do {
            if ((answer = this.waitForAnswer(ChannelEnum.PS, ChannelCommandEnum.STAT, 3000)) != null) {
                if (answer.message.length() == 0) continue;
                ret.add(String.valueOf(SHelpers.indent(1)) + answer.message);
                continue;
            }
            ret.add(String.valueOf(SHelpers.indent(1)) + "No answer from process");
            break;
        } while (answer.message.length() != 0);
        return ret;
    }
}

