/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.EnumHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.control.ControlMethodEnum;
import ikr.simtree.control.ControlMethodParameterEnum;
import ikr.simtree.control.ControlRequest;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.HelpTextExtractor;
import ikr.simtree.help.SimpleHelpPara;
import ikr.simtree.help.TwoColHelpPara;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import java.util.ArrayList;

public enum ControlObjectEnum {
    SLOTS(new ControlMethodEnum[]{ControlMethodEnum.LIST, ControlMethodEnum.ADD, ControlMethodEnum.REMOVE}, new ControlMethodParameterEnum[0], new OptionEnum[]{OptionEnum.LOCAL_PROCESS_SLOTS, OptionEnum.REMOTE_PROCESS_SLOTS}),
    WS(new ControlMethodEnum[]{ControlMethodEnum.LIST, ControlMethodEnum.ADD, ControlMethodEnum.REMOVE}, new ControlMethodParameterEnum[]{ControlMethodParameterEnum.RUNNING, ControlMethodParameterEnum.WAITING, ControlMethodParameterEnum.FINISHED}, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.BATCHES, OptionEnum.DROPS}),
    PROCS(new ControlMethodEnum[]{ControlMethodEnum.LIST, ControlMethodEnum.KILL}, new ControlMethodParameterEnum[0], new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.BATCHES, OptionEnum.DROPS});

    private final ControlMethodEnum[] allowedMethods;
    private final ControlMethodParameterEnum[] allowedParameters;
    private final OptionEnum[] allowedOptions;

    private ControlObjectEnum(ControlMethodEnum[] allowedMethods, ControlMethodParameterEnum[] allowedParameters, OptionEnum[] allowedOptions) {
        this.allowedMethods = allowedMethods;
        this.allowedParameters = allowedParameters;
        this.allowedOptions = allowedOptions;
    }

    public static ControlRequest parse(String ccArg, Options options) throws SimTreeException {
        int n;
        Enum[] enumArray;
        ControlObjectEnum controlObject = null;
        ControlMethodEnum controlMethod = null;
        ArrayList<ControlMethodParameterEnum> controlMethodParameters = new ArrayList<ControlMethodParameterEnum>();
        String[] parts = ccArg.split("\\Q.\\E");
        if (parts.length != 2) {
            throw new SimTreeException("Missing control object in request " + ccArg);
        }
        controlObject = (ControlObjectEnum)EnumHelpers.matchEnum(ControlObjectEnum.values(), parts[0]);
        if (controlObject == null) {
            throw new SimTreeException("Unknown control object " + parts[0]);
        }
        parts = parts[1].split("\\Q-\\E");
        controlMethod = (ControlMethodEnum)EnumHelpers.matchEnum(ControlMethodEnum.values(), parts[0]);
        if (controlMethod == null) {
            throw new SimTreeException("Unknown control method " + parts[0]);
        }
        int p = 1;
        while (p < parts.length) {
            ControlMethodParameterEnum para = (ControlMethodParameterEnum)EnumHelpers.matchEnum(ControlMethodParameterEnum.values(), parts[p]);
            if (para == null) {
                throw new SimTreeException("Unknown control method parameter " + parts[p]);
            }
            controlMethodParameters.add(para);
            ++p;
        }
        boolean found = false;
        ControlMethodEnum[] controlMethodEnumArray = controlObject.allowedMethods;
        int n2 = controlObject.allowedMethods.length;
        int n3 = 0;
        while (n3 < n2) {
            ControlMethodEnum m = controlMethodEnumArray[n3];
            if (m == controlMethod) {
                found = true;
            }
            ++n3;
        }
        if (!found) {
            throw new SimTreeException("Method " + controlMethod.name().toLowerCase() + " not allowed for object " + controlObject.name().toLowerCase());
        }
        found = false;
        for (ControlMethodParameterEnum p2 : controlMethodParameters) {
            found = false;
            enumArray = controlObject.allowedParameters;
            n = controlObject.allowedParameters.length;
            int n4 = 0;
            while (n4 < n) {
                ControlMethodParameterEnum pp = enumArray[n4];
                if (p2 == pp) {
                    found = true;
                }
                ++n4;
            }
            if (found) continue;
            throw new SimTreeException("Parameter " + p2.name().toLowerCase() + " not allowed for object " + controlObject.name().toLowerCase());
        }
        for (Option o : options) {
            if (o.optionEnum == OptionEnum.CONTROL_COMMAND) continue;
            found = false;
            enumArray = controlObject.allowedOptions;
            n = controlObject.allowedOptions.length;
            int n5 = 0;
            while (n5 < n) {
                Enum oo = enumArray[n5];
                if (o.optionEnum == oo) {
                    found = true;
                }
                ++n5;
            }
            if (found) continue;
            throw new SimTreeException("Option " + o.optionEnum.name().toLowerCase() + " not allowed for object " + controlObject.name().toLowerCase());
        }
        return new ControlRequest(controlObject, controlMethod, controlMethodParameters);
    }

    public static Options getFilteredOptions(ControlObjectEnum controlObject, Options options, SimTreeContext sc) {
        Options ret = new Options(sc);
        for (Option o : options) {
            boolean found = false;
            if (o.optionEnum == OptionEnum.CONTROL_COMMAND) {
                found = true;
            } else {
                OptionEnum[] optionEnumArray = controlObject.allowedOptions;
                int n = controlObject.allowedOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    OptionEnum oo = optionEnumArray[n2];
                    if (o.optionEnum == oo) {
                        found = true;
                    }
                    ++n2;
                }
            }
            if (!found) continue;
            ret.add(o);
        }
        return ret;
    }

    public HelpParas getFullHelp(int indent) throws SimTreeException {
        HelpParas ret = new HelpParas();
        ret.addAll(HelpTextExtractor.getHelpSectionParas(indent, "Description", "control", this.name().toLowerCase(), null));
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, "Supported methods"));
        TwoColHelpPara th = new TwoColHelpPara(HelpParaTypeEnum.E0, indent, 26);
        Enum[] enumArray = this.allowedMethods;
        int n = this.allowedMethods.length;
        int n2 = 0;
        while (n2 < n) {
            ControlMethodEnum cm = enumArray[n2];
            th.addLine(new StringPair(cm.name().toLowerCase(), cm.helpLine));
            ++n2;
        }
        ret.add(th);
        ret.addGapAfter();
        if (this.allowedParameters.length != 0) {
            ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, "Supported parameters"));
            th = new TwoColHelpPara(HelpParaTypeEnum.E0, indent, 26);
            enumArray = this.allowedParameters;
            n = this.allowedParameters.length;
            n2 = 0;
            while (n2 < n) {
                Enum cp = enumArray[n2];
                th.addLine(new StringPair(cp.name().toLowerCase(), ((ControlMethodParameterEnum)cp).helpLine));
                ++n2;
            }
            ret.add(th);
            ret.addGapAfter();
        }
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, "Supported options"));
        ret.add(OptionEnum.getShortHelpForOptionArray(this.allowedOptions, 1));
        return ret;
    }

    public String toDisplayString() {
        return this.toString().toLowerCase();
    }
}

