/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.eval.EvalResults;
import ikr.simtree.graphwriter.ResultPath;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.ResultDefOption;
import ikr.simtree.options.ResultPathOption;
import ikr.simtree.parser.ParserTask;
import ikr.simtree.parser.ResultFilesParser;
import ikr.simtree.query.ParserHandlerConfig;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.resultdef.ResultDefs;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.WorkItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class WalkerParseCommand
extends WalkerCommand {
    protected final List<ResultPath> resultPathes = new ArrayList<ResultPath>();
    protected ResultDefs resultDefs;
    protected EvalResults evalResults;
    private final ParserHandlerConfig parserHandlerConfig;
    private LinkedBlockingQueue<ParserTask> parserTaskQueue;
    private CountDownLatch countDownLatch;
    private int numThreads;

    protected WalkerParseCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc, ParserHandlerConfig parserHandlerConfig) {
        super(commandDesc, optionList, sc, true);
        this.parserHandlerConfig = parserHandlerConfig;
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        ResultDefOption resultDefOption = this.getCheckedResultDefOption();
        if (resultDefOption != null) {
            this.resultDefs = resultDefOption.getResultDefs();
        }
        Options resultPathOptions = this.getOptions(OptionEnum.RESULT_PATH);
        for (Option option : resultPathOptions) {
            this.resultPathes.add(((ResultPathOption)option).getResultSource());
        }
        Options columnDefOptions = this.getOptions(OptionEnum.COLUMN_DEFINITION);
        for (Option option : columnDefOptions) {
            ColumnDefinitionOption cdo = (ColumnDefinitionOption)option;
            if (cdo.getColKind() != ColumnDefinitionOption.ColKindEnum.RESULT_PATH) continue;
            this.resultPathes.add(cdo.getResultSource());
        }
        this.evalResults = new EvalResults();
        this.numThreads = Props.getInt("st.i.num_parser_threads.1");
        if (this.numThreads <= 0) {
            throw new SimTreeException("Invalid number of parser threads, must be > 0");
        }
        this.countDownLatch = new CountDownLatch(this.numThreads);
        this.parserTaskQueue = new LinkedBlockingQueue();
        int i = 0;
        while (i < this.numThreads) {
            Thread t = new Thread(new ResultFilesParser(this.parserTaskQueue, this.countDownLatch, this.sc));
            t.setPriority(1);
            t.start();
            ++i;
        }
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        try {
            int i = 0;
            while (i < this.numThreads) {
                this.parserTaskQueue.put(new ParserTask());
                ++i;
            }
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collections.sort(this.evalResults);
    }

    /*
     * Unable to fully structure code
     */
    private ParserTask createParserTask(SimParaPath currentPath) throws SimTreeException {
        parserTask = null;
        vfs = new ResultNodeVFS(currentPath, this.sc);
        currentPathString = currentPath.toFormattedString();
        if (this.resultDefs == null) ** GOTO lbl15
        for (ResultDef resultDef : this.resultDefs) {
            if (!vfs.isLocked(resultDef)) continue;
            Message.warning("At least one result directory for path " + currentPathString + " is locked, skipping path", this.sc);
            return null;
        }
        resultFiles = vfs.getExistingResultFiles(this.resultDefs);
        if (resultFiles.size() != 0) {
            parserTask = new ParserTask(resultFiles, currentPath, this.evalResults, this.parserHandlerConfig);
        } else {
            Message.warning("No result files for " + currentPathString + " found", this.sc);
            return null;
lbl15:
            // 1 sources

            if (vfs.isLocked((ResultDef)null)) {
                Message.warning("Directory for path " + currentPathString + " is locked, skipping", this.sc);
                return null;
            }
            resultFile = vfs.getFinalResultsFile();
            if (resultFile != null && resultFile.exists()) {
                parserTask = new ParserTask(resultFile, currentPath, this.evalResults, this.parserHandlerConfig);
            } else {
                Message.warning("FinalResults for path " + currentPathString + " not found, skipping", this.sc);
                return null;
            }
        }
        if (!WalkerParseCommand.$assertionsDisabled && parserTask == null) {
            throw new AssertionError();
        }
        for (ResultPath rs : this.resultPathes) {
            parserTask.addQuery(rs.getExpandedPath(), rs.getResultName());
        }
        return parserTask;
    }

    @Override
    void handleWorkItem(WorkItem workItem) throws SimTreeException {
        assert (workItem.workDesc.resultDef == null);
        ParserTask parserTask = this.createParserTask(workItem.workDesc.simParaPath);
        if (parserTask != null) {
            try {
                this.parserTaskQueue.put(parserTask);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.actionCount;
        }
        workItem.fromRunningToFinished();
    }
}

