/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.results.node.ResultNodeContent;
import ikr.simtree.vfs.results.node.SimulationMethodEnum;
import ikr.simtree.vfs.results.tree.ResultsTreeState;

public class ListLine {
    private static final String PR_INDENT = "%%indent%%";
    private static final String PR_CONTENT = "%%content%%";
    private static final String PR_COMMAND_ADDSPP = "%%command_addspp%%";
    private static final String PR_DIRNAME = "%%dirname%%";
    private static final String PR_FULLCONTENT = "%%fullcontent%%";
    private static final String PR_SPNAME = "%%spname%%";
    private static final String PR_VALUE = "%%value%%";
    protected SimParaPath simParaPath;
    protected ResultNodeContent resultNodeContent = null;
    private static final String nameFormatString = String.valueOf(SHelpers.indent(4)) + "%-25s ";
    private static final String baseIncr = SHelpers.indent(1);
    private final String printFormat;
    private final SimTreeContext sc;

    protected ListLine(String printFormat, SimTreeContext sc) {
        this.printFormat = printFormat;
        this.sc = sc;
    }

    protected void setResultNodeContent(ResultNodeContent resultNodeContent) {
        this.resultNodeContent = resultNodeContent;
    }

    protected static String getStringForJTreeView(SimPara simPara) {
        return ListLine.getStringForJTreeView(simPara, null);
    }

    private static String getStringForJTreeView(SimPara simPara, String contentString) {
        return "<html>" + simPara.getParaName() + "&nbsp;&nbsp;&nbsp;&nbsp;" + simPara.getStringValue() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(" + simPara.getTypeName() + ")" + (contentString == null ? "" : "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>[" + contentString + "]</i>") + "</html>";
    }

    protected String getStringForJTreeView() {
        return ListLine.getStringForJTreeView((SimPara)this.simParaPath.get(this.simParaPath.size() - 1), this.getContentString());
    }

    public static Strings getHeader(String printFormat) {
        Strings ret = new Strings();
        if (printFormat.contains(PR_CONTENT) || printFormat.contains(PR_FULLCONTENT)) {
            ret.add("Meaning of symbols");
            ret.add(String.valueOf(baseIncr) + "F - - - - - - -  Final results exists");
            ret.add(String.valueOf(baseIncr) + "- E - - - - - -  Directory is empty");
            ret.add(String.valueOf(baseIncr) + "- - L - - - - -  Directory is locked");
            ret.add(String.valueOf(baseIncr) + "- - - B - - - -  Default batches exists");
            ret.add(String.valueOf(baseIncr) + "- - - - S - - -  Seeded results exists");
            ret.add(String.valueOf(baseIncr) + "- - - - - R - -  Export results exists");
            ret.add(String.valueOf(baseIncr) + "- - - - - - X -  Seed directories are locked");
            ret.add(String.valueOf(baseIncr) + "- - - - - - - W  Directory is not empty (may contain foreign files, see Option" + OptionEnum.FORCE_DELETE_FOREIGN_FILES.hlp10 + ")");
        }
        return ret;
    }

    protected Strings getResultNamesForVisualView() {
        assert (this.resultNodeContent.defaultBatches.size() == 0 || this.resultNodeContent.defaultBatches.size() == 1);
        Strings ret = new Strings();
        if (this.resultNodeContent.defaultBatches.size() == 1) {
            ResultDef resultDef = (ResultDef)this.resultNodeContent.defaultBatches.get(0);
            for (Integer i : resultDef.getPartTestNums()) {
                ret.add(resultDef.getDisplayStringForOneRunNum(i));
            }
        }
        for (ResultDef resultDef : this.resultNodeContent.seededBatches) {
            for (Integer i : resultDef.getPartTestNums()) {
                ret.add(resultDef.getDisplayStringForOneRunNum(i));
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    protected Strings getLines() throws SimTreeException {
        ret = new Strings();
        contentShown = false;
        commandShown = false;
        dirShown = false;
        indentDone = false;
        addFullContent = false;
        if (!ListLine.$assertionsDisabled && this.simParaPath == null) {
            throw new AssertionError();
        }
        thisLine = "";
        for (SimPara simPara : this.simParaPath) {
            current = 0;
            ** GOTO lbl61
            {
                thisLine = String.valueOf(thisLine) + c;
                ++current;
                do {
                    if (current < this.printFormat.length() && (c = this.printFormat.charAt(current)) != '%') continue block1;
                    if (this.printFormat.length() == 0) continue;
                    if (this.printFormat.startsWith("%%command_addspp%%", current)) {
                        if (!commandShown) {
                            thisLine = String.valueOf(thisLine) + "SimTree " + CommandEnum.ADD.toString().toLowerCase() + " " + this.simParaPath.toFormattedString(SimPara.FormatEnum.OPTION_SHORT);
                            commandShown = true;
                        }
                        current += "%%command_addspp%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%content%%", current)) {
                        if (!contentShown) {
                            thisLine = String.valueOf(thisLine) + this.getContentString();
                            contentShown = true;
                        }
                        current += "%%content%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%fullcontent%%", current)) {
                        if (!contentShown) {
                            thisLine = String.valueOf(thisLine) + this.getContentString();
                            contentShown = true;
                            addFullContent = true;
                        }
                        current += "%%fullcontent%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%spname%%", current)) {
                        thisLine = String.valueOf(thisLine) + simPara.getParaName();
                        current += "%%spname%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%dirname%%", current)) {
                        if (!dirShown) {
                            thisLine = String.valueOf(thisLine) + this.simParaPath.toAbsoluteDirName();
                            dirShown = true;
                        }
                        current += "%%dirname%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%indent%%", current)) {
                        if (!indentDone) {
                            thisLine = String.valueOf(thisLine) + SHelpers.indent(6);
                            indentDone = true;
                        }
                        current += "%%indent%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%value%%", current)) {
                        thisLine = String.valueOf(thisLine) + simPara.getStringValue();
                        current += "%%value%%".length();
                        continue;
                    }
                    if (this.printFormat.startsWith("%%", current)) {
                        throw new SimTreeException("Invalid format string");
                    }
                    thisLine = String.valueOf(thisLine) + this.printFormat.substring(current, current);
                    ++current;
lbl61:
                    // 10 sources

                } while (current < this.printFormat.length());
            }
        }
        if (thisLine.length() != 0) {
            ret.add(thisLine);
        }
        if (addFullContent) {
            ret.addAll(this.getFullContentLines());
        }
        return ret;
    }

    private String getContentString() {
        String e = "- ";
        return String.valueOf(this.resultNodeContent.finalResultFileExist ? "F " : "- ") + (this.resultNodeContent.isDirEmpty ? "E " : "- ") + (this.resultNodeContent.isLocked ? "L " : "- ") + (this.resultNodeContent.defaultBatches.size() != 0 ? "B " : "- ") + (this.resultNodeContent.seededBatches.size() != 0 ? "S " : "- ") + (this.resultNodeContent.exportResults.size() != 0 ? "R " : "- ") + (this.resultNodeContent.lockedSeeds.size() != 0 ? "X " : "- ") + (this.resultNodeContent.mayContainForeignFiles ? "W " : "- ");
    }

    private Strings getFullContentLines() throws SimTreeException {
        Strings ret = new Strings();
        SimulationMethodEnum simulationMethod = ResultsTreeState.getSimulationMethod(false, this.sc);
        String res = "";
        if (simulationMethod == SimulationMethodEnum.INDEPENDENT_REPLICATION) {
            res = "Drops";
        } else if (simulationMethod == SimulationMethodEnum.BATCH_MEAN) {
            res = "Seeded batches";
        }
        ret.addAll(ListLine.printResultList(this.resultNodeContent.defaultBatches.toDisplayStrings(), "Default (non seeded) batches"));
        ret.addAll(ListLine.printResultList(this.resultNodeContent.seededBatches.toDisplayStrings(), res));
        ret.addAll(ListLine.printResultList(this.resultNodeContent.exportResults.toDisplayStrings(), "Export result files"));
        ret.addAll(ListLine.printResultList(this.resultNodeContent.lockedSeeds.toDisplayStrings(), "Locked seeded batches"));
        if (ret.size() != 0) {
            ret.add("");
        }
        return ret;
    }

    private static Strings printResultList(Strings displayStrings, String name) {
        Strings ret = new Strings();
        for (String s : displayStrings) {
            if (ret.size() == 0) {
                ret.add(String.valueOf(SHelpers.indent(7)) + String.format(nameFormatString, name) + s);
                continue;
            }
            ret.add(String.valueOf(SHelpers.indent(7)) + String.format(nameFormatString, " ") + s);
        }
        return ret;
    }

    protected void commit() throws SimTreeException {
        for (String str : this.getLines()) {
            Message.evalResultOut(str);
        }
    }
}

