/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commandline.UnparsedOption;
import ikr.simtree.commandline.UnparsedOptions;
import ikr.simtree.commands.Command;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.TextFormatter;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;

public class HelpCommand
extends Command {
    private HelpCommand(CommandDesc commandDesc, Options optionList, SimTreeContext simTreeContext) {
        super(commandDesc, optionList, simTreeContext);
    }

    @Override
    public void doIt() {
        assert (false);
    }

    public static void doItStatic(CommandDesc commandDesc, UnparsedOptions unparsedOptions, SimTreeContext sc) throws SimTreeException {
        HelpParas helpParas = new HelpParas();
        if (unparsedOptions == null || unparsedOptions.size() == 0) {
            helpParas.addAll(CommandEnum.getAllListHelp(0));
        } else {
            for (UnparsedOption option : unparsedOptions) {
                OptionEnum optionEnum = OptionEnum.fromUnparsedOption(option);
                if (optionEnum == null) {
                    Message.warning("Invalid option " + option.optionName, sc);
                    continue;
                }
                helpParas.addAll(optionEnum.getFullHelp(0));
            }
        }
        if (helpParas.size() != 0) {
            ((HelpPara)helpParas.get(0)).addGapBefore();
            new TextFormatter(helpParas).print();
        } else {
            Message.warning("No help content found", sc);
        }
    }
}

