/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.Props;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.cmdrun.CommandReturn;
import ikr.simtree.cmdrun.CommandRunner;
import ikr.simtree.commands.Command;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.control.channel.ChannelCommandEnum;
import ikr.simtree.control.channel.ChannelEnum;
import ikr.simtree.control.channel.ChannelMessage;
import ikr.simtree.control.channel.UpstreamMessageCollector;
import ikr.simtree.hooks.HookFileCreator;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ExecCommand
extends Command {
    protected ExecCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc);
    }

    @Override
    public void doIt() throws SimTreeException {
        String workingDirName = this.getSingleArgOption(OptionEnum.WORKING_DIRECTORY).getSingleArg();
        File workingDir = new File(workingDirName);
        if (!workingDir.isDirectory() || !workingDir.canWrite()) {
            throw new SimTreeException("Working directory does not exist or is not writable");
        }
        File commandFile = new File(workingDir + File.separator + "simtree-callsim");
        if (!FileOPs.isFileReadable(commandFile)) {
            throw new SimTreeException("Command file " + commandFile.getAbsolutePath() + " does not exist or is not readable");
        }
        String command = commandFile.getAbsolutePath();
        Message.notice("Starting  [" + command + "]", this.sc);
        Message.notice(String.valueOf(SHelpers.indent(1)) + "in working dir [" + workingDir.getAbsolutePath() + "]", this.sc);
        Message.notice(String.valueOf(SHelpers.indent(1)) + "on host [" + Helpers.getHostName() + "]", this.sc);
        String base = String.valueOf(StudyRootVFS.getFileBasenameWithDash()) + Props.getStr("st.s.redir_filename_mid.2");
        boolean createOutputFiles = Props.getBool("st.b.create_output_files.1");
        String fNameStdOut = createOutputFiles ? String.valueOf(base) + Props.getStr("st.s.redir_out_filename_ext.1") : null;
        String fNameStdErr = createOutputFiles ? String.valueOf(base) + Props.getStr("st.s.redir_err_filename_ext.1") : null;
        CommandOutputHandler commandStdoutHandler = new CommandOutputHandler(false, true, fNameStdOut, true);
        UpstreamMessageCollector upstreamMessageCollector = commandStdoutHandler.getUpstreamMessageCollector();
        new Thread(new ChannelHandler(workingDirName, upstreamMessageCollector)).start();
        CommandReturn commandReturn = new CommandRunner(workingDirName, this.sc).run(command, commandStdoutHandler, new CommandOutputHandler(false, true, fNameStdErr, false));
        Helpers.setExitValue(commandReturn.exitValue);
        Helpers.exitProgram();
    }

    private class ChannelHandler
    implements Runnable {
        private final UpstreamMessageCollector upstreamMessageCollector;
        private final String workingDirName;

        public ChannelHandler(String workingDirName, UpstreamMessageCollector upstreamMessageCollector) {
            this.upstreamMessageCollector = upstreamMessageCollector;
            this.workingDirName = workingDirName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int childPID = -1;
            do {
                ChannelMessage msg = null;
                while (msg == null) {
                    msg = this.upstreamMessageCollector.waitAndRetrieve(ChannelEnum.EXEC, ChannelCommandEnum.PID, 2000);
                }
                try {
                    childPID = Integer.parseInt(msg.message);
                }
                catch (NumberFormatException e) {
                    Message.error("Received invalid PID from child", ExecCommand.this.sc);
                }
            } while (childPID == -1);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                while (true) {
                    String stdinString;
                    if ((stdinString = reader.readLine()) == null) {
                        return;
                    }
                    ChannelMessage chm = ChannelMessage.splitMessage(stdinString);
                    if (chm == null || chm.channel != ChannelEnum.PS) continue;
                    HookFileCreator hookFileCreator = new HookFileCreator("process-controller");
                    hookFileCreator.addStringReplacement("PROC_ID", "" + childPID);
                    hookFileCreator.addStringReplacement("COMMAND", chm.command.getCommandName());
                    try {
                        hookFileCreator.createAndExecute(new CommandRunner(this.workingDirName, ExecCommand.this.sc), new CommandOutputHandler(false, true, null, false), CommandOutputHandler.simpleCommandOutputHandler);
                    }
                    catch (SimTreeException e) {
                        Message.error(e.getMessage(), ExecCommand.this.sc);
                    }
                }
                break;
            }
            catch (IOException e) {
                Message.error("Error while reading input from simulation binary: " + e.getMessage(), ExecCommand.this.sc);
            }
        }
    }
}

