/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.commands.WalkerParseCommand;
import ikr.simtree.eval.EvalResultsWriter;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.GraphWriterOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.query.ParserHandlerConfig;

public class EvalCommand
extends WalkerParseCommand {
    private Options sortedColDefs;

    protected EvalCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, new ParserHandlerConfig(false, true));
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        Options colDefs = this.getOptions(OptionEnum.COLUMN_DEFINITION);
        this.sortedColDefs = new Options(this.sc);
        int i = 0;
        while (i < colDefs.size()) {
            int j = 0;
            while (j < colDefs.size()) {
                ColumnDefinitionOption cod = (ColumnDefinitionOption)colDefs.get(j);
                if (cod.getColNum() == i) {
                    this.sortedColDefs.add(cod);
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (colDefs.size() != this.sortedColDefs.size()) {
            throw new SimTreeException("Invalid column definitions, must start with 0 and be consecutive");
        }
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        GraphWriterOption gwo = (GraphWriterOption)this.getOption(OptionEnum.GRAPH_WRITER);
        assert (gwo != null);
        if (this.actionCount != 0) {
            new EvalResultsWriter(this.evalResults, this.hasCommandVariant(CommandVariantEnum.VISUAL), this.sc).resultsForEvalToGraphData(gwo.getGraphWriterEnum(), gwo.getAdditionalArguments(), this.sortedColDefs);
        }
        Message.notice("Results for " + this.actionCount + " simulation parameter values evaluated", this.sc);
    }
}

