/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.cmdrun.CommandReturn;
import ikr.simtree.commands.Command;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.control.ControlObjectEnum;
import ikr.simtree.control.ControlRequest;
import ikr.simtree.control.comm.ControlClientRunner;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ControlCommandOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;

public class ControlCommand
extends Command {
    private final Options options;

    protected ControlCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc);
        this.options = optionList;
    }

    @Override
    public void doIt() throws SimTreeException {
        ControlCommandOption ccOption = (ControlCommandOption)this.getOption(OptionEnum.CONTROL_COMMAND);
        assert (ccOption != null);
        Options emptyOptions = new Options(this.sc);
        ControlRequest controlRequest = ControlObjectEnum.parse(ccOption.getSingleArg(), emptyOptions);
        Options filteredOptions = ControlObjectEnum.getFilteredOptions(controlRequest.controlObject, this.options, this.sc);
        CommandOutputHandler stdoutSpec = new CommandOutputHandler(true, false, null, false);
        CommandReturn commandReturn = ControlClientRunner.factory().run(filteredOptions.toCommandLine(), stdoutSpec, this.sc);
        if (commandReturn.exitValue == 20) {
            throw new SimTreeException("Cannot connect, is a SimTree parent process running on this host?");
        }
        if (commandReturn.exitValue != 0) {
            throw new SimTreeException("Cannot connect to remote SimTree process (" + commandReturn.exitValue + ")");
        }
        Message.status("Connect succeded, result shown below", this.sc);
        if (stdoutSpec.getStringList().isEmpty()) {
            Message.status("(No answer)", this.sc);
        } else {
            for (String s : stdoutSpec.getStringList()) {
                Message.remote(s, this.sc);
            }
        }
    }
}

